// SPDX-FileCopyrightText: 2023 Jaime Marquínez Ferrándiz <jaime.marquinez.ferrandiz@fastmail.net>
//
// SPDX-License-Identifier: GPL-2.0-or-later

#ifndef QIMAGECOMPAT_H
#define QIMAGECOMPAT_H

#include <QImage>

class QImageCompat
{
public:

#if (QT_VERSION >= QT_VERSION_CHECK(5, 10, 0))
    static inline qsizetype sizeInBytes(QImage image)
    {
        return image.sizeInBytes();
    }
#else
    static inline int sizeInBytes(QImage image)
    {
        return image.byteCount();
    }
#endif
};

#endif // QIMAGECOMPAT_H
