const defaults = {
  "PARTITION_HIGHLIGHT_COLOR": "#28a745",
  "PARTITION_HIGHLIGHT_COLOR_CONTRAST": "#f8f9fa",
  "PARTITION_MPD_STREAM_PORT": 8000,
  "MYMPD_MPD_TAG_LIST": "Album,AlbumArtist,Artist,Disc,Genre,Name,Title,Track,Name,Date,OriginalDate,MUSICBRAINZ_ALBUMID,MUSICBRAINZ_ALBUMARTISTID,MUSICBRAINZ_ARTISTID,MUSICBRAINZ_RELEASETRACKID,MUSICBRAINZ_TRACKID",
  "MYMPD_MPD_KEEPALIVE": true,
  "MYMPD_MPD_TIMEOUT_SEC": 30,
  "MYMPD_MPD_TIMEOUT": 30000,
  "MYMPD_MPD_HOST": "localhost",
  "MYMPD_MPD_PORT": 6600,
  "MYMPD_MPD_BINARYLIMIT": 524288,
  "MYMPD_MPD_STRINGNORMALIZATION": true,
  "MYMPD_MUSIC_DIRECTORY": "auto",
  "MYMPD_PLAYLIST_DIRECTORY": "auto",
  "MYMPD_JUKEBOX_PLAYLIST": "Database",
  "MYMPD_JUKEBOX_UNIQ_TAG": "Artist",
  "MYMPD_JUKEBOX_LAST_PLAYED": 24,
  "MYMPD_JUKEBOX_QUEUE_LENGTH": 1,
  "MYMPD_JUKEBOX_IGNORE_HATED": false,
  "MYMPD_JUKEBOX_AUTOSTART": true,
  "MYMPD_JUKEBOX_MIN_SONG_DURATION": 0,
  "MYMPD_JUKEBOX_MAX_SONG_DURATION": 0,
  "MYMPD_IMAGE_NAMES_SM": "cover-sm,folder-sm",
  "MYMPD_IMAGE_NAMES_MD": "cover,folder",
  "MYMPD_IMAGE_NAMES_LG": "cover-lg,folder-lg",
  "MYMPD_TAG_LIST_SEARCH": "Album,AlbumArtist,Artist,Genre,Title",
  "MYMPD_TAG_LIST_BROWSE": "Album,AlbumArtist,Artist,Genre",
  "MYMPD_LAST_PLAYED_COUNT": 2000,
  "MYMPD_SMARTPLS": true,
  "MYMPD_SMARTPLS_PREFIX": "myMPDsmart",
  "MYMPD_SMARTPLS_MAX_ENTRIES_DEFAULT": 200,
  "MYMPD_SMARTPLS_INTERVAL": 14400,
  "MYMPD_SMARTPLS_INTERVAL_HOURS": 4,
  "MYMPD_BOOKLET_NAME": "booklet.pdf",
  "MYMPD_INFO_TXT_NAME": "info.txt",
  "MYMPD_AUTO_PLAY": false,
  "MYMPD_VIEW_HOME": {
    "mode": "grid",
    "fields": [
      "Name"
    ]
  },
  "MYMPD_VIEW_QUEUE_CURRENT": {
    "mode": "table",
    "fields": [
      "Pos",
      "Title",
      "Artist",
      "Album",
      "Duration"
    ]
  },
  "MYMPD_VIEW_SEARCH": {
    "mode": "table",
    "fields": [
      "Title",
      "Artist",
      "Album",
      "Duration"
    ]
  },
  "MYMPD_VIEW_BROWSE_DATABASE_ALBUM_DETAIL_INFO": {
    "mode": "table",
    "fields": [
      "Album",
      "AlbumArtist",
      "Genre"
    ]
  },
  "MYMPD_VIEW_BROWSE_DATABASE_ALBUM_DETAIL": {
    "mode": "table",
    "fields": [
      "Track",
      "Title",
      "Duration"
    ]
  },
  "MYMPD_VIEW_BROWSE_DATABASE_ALBUM_LIST": {
    "mode": "grid",
    "fields": [
      "Album",
      "AlbumArtist",
      "Thumbnail"
    ]
  },
  "MYMPD_VIEW_BROWSE_DATABASE_TAG_LIST": {
    "mode": "grid",
    "fields": [
      "Value"
    ]
  },
  "MYMPD_VIEW_BROWSE_PLAYLIST_DETAIL": {
    "mode": "table",
    "fields": [
      "Pos",
      "Title",
      "Artist",
      "Album",
      "Duration"
    ]
  },
  "MYMPD_VIEW_BROWSE_PLAYLIST_LIST": {
    "mode": "table",
    "fields": [
      "Type",
      "Name",
      "Last-Modified"
    ]
  },
  "MYMPD_VIEW_BROWSE_FILESYSTEM": {
    "mode": "table",
    "fields": [
      "Pos",
      "Title",
      "Artist",
      "Album",
      "Duration"
    ]
  },
  "MYMPD_VIEW_PLAYBACK": {
    "mode": "table",
    "fields": [
      "Artist",
      "Album"
    ]
  },
  "MYMPD_VIEW_QUEUE_LAST_PLAYED": {
    "mode": "table",
    "fields": [
      "Pos",
      "Title",
      "Artist",
      "Album",
      "LastPlayed"
    ]
  },
  "MYMPD_VIEW_QUEUE_JUKEBOX_SONG": {
    "mode": "table",
    "fields": [
      "Pos",
      "Title",
      "Artist",
      "Album"
    ]
  },
  "MYMPD_VIEW_QUEUE_JUKEBOX_ALBUM": {
    "mode": "table",
    "fields": [
      "Pos",
      "Album",
      "AlbumArtist"
    ]
  },
  "MYMPD_VIEW_BROWSE_RADIO_WEBRADIODB": {
    "mode": "table",
    "fields": [
      "Name",
      "Country",
      "Language",
      "Genre"
    ]
  },
  "MYMPD_VIEW_BROWSE_RADIO_FAVORITES": {
    "mode": "grid",
    "fields": [
      "Name",
      "Genre",
      "Country"
    ]
  },
  "MYMPD_VOLUME_MIN": 0,
  "MYMPD_VOLUME_MAX": 100,
  "MYMPD_VOLUME_STEP": 5,
  "MYMPD_WEBUI_SETTINGS": {},
  "MYMPD_LYRICS_USLT_EXT": "txt",
  "MYMPD_LYRICS_SYLT_EXT": "lrc",
  "MYMPD_LYRICS_VORBIS_USLT": "LYRICS",
  "MYMPD_LYRICS_VORBIS_SYLT": "SYNCEDLYRICS",
  "MYMPD_NAVBAR_ICONS": [
    {
      "ligature": "home",
      "title": "Home",
      "options": [
        "Home"
      ]
    },
    {
      "ligature": "equalizer",
      "title": "Playback",
      "options": [
        "Playback"
      ]
    },
    {
      "ligature": "queue_music",
      "title": "Queue",
      "options": [
        "Queue"
      ]
    },
    {
      "ligature": "library_music",
      "title": "Browse",
      "options": [
        "Browse"
      ]
    },
    {
      "ligature": "search",
      "title": "Search",
      "options": [
        "Search"
      ]
    }
  ],
  "MYMPD_TAG_DISC_EMPTY_IS_FIRST": true
}
;
