// Code generated by 'go generate'; DO NOT EDIT.

package gp

import (
	"syscall"
	"unsafe"

	"golang.org/x/sys/windows"
)

var _ unsafe.Pointer

// Do the interface allocations only once for common
// Errno values.
const (
	errnoERROR_IO_PENDING = 997
)

var (
	errERROR_IO_PENDING error = syscall.Errno(errnoERROR_IO_PENDING)
	errERROR_EINVAL     error = syscall.EINVAL
)

// errnoErr returns common boxed Errno values, to prevent
// allocations at runtime.
func errnoErr(e syscall.Errno) error {
	switch e {
	case 0:
		return errERROR_EINVAL
	case errnoERROR_IO_PENDING:
		return errERROR_IO_PENDING
	}
	// TODO: add more here, after collecting data on the common
	// error values see on Windows. (perhaps when running
	// all.bat?)
	return e
}

var (
	modadvapi32 = windows.NewLazySystemDLL("advapi32.dll")
	moduserenv  = windows.NewLazySystemDLL("userenv.dll")

	procImpersonateLoggedOnUser    = modadvapi32.NewProc("ImpersonateLoggedOnUser")
	procEnterCriticalPolicySection = moduserenv.NewProc("EnterCriticalPolicySection")
	procLeaveCriticalPolicySection = moduserenv.NewProc("LeaveCriticalPolicySection")
	procRefreshPolicyEx            = moduserenv.NewProc("RefreshPolicyEx")
	procRegisterGPNotification     = moduserenv.NewProc("RegisterGPNotification")
	procUnregisterGPNotification   = moduserenv.NewProc("UnregisterGPNotification")
)

func impersonateLoggedOnUser(token windows.Token) (err error) {
	r1, _, e1 := syscall.Syscall(procImpersonateLoggedOnUser.Addr(), 1, uintptr(token), 0, 0)
	if int32(r1) == 0 {
		err = errnoErr(e1)
	}
	return
}

func enterCriticalPolicySection(machine bool) (handle policyLockHandle, err error) {
	var _p0 uint32
	if machine {
		_p0 = 1
	}
	r0, _, e1 := syscall.Syscall(procEnterCriticalPolicySection.Addr(), 1, uintptr(_p0), 0, 0)
	handle = policyLockHandle(r0)
	if int32(handle) == 0 {
		err = errnoErr(e1)
	}
	return
}

func leaveCriticalPolicySection(handle policyLockHandle) (err error) {
	r1, _, e1 := syscall.Syscall(procLeaveCriticalPolicySection.Addr(), 1, uintptr(handle), 0, 0)
	if int32(r1) == 0 {
		err = errnoErr(e1)
	}
	return
}

func refreshPolicyEx(machine bool, flags uint32) (err error) {
	var _p0 uint32
	if machine {
		_p0 = 1
	}
	r1, _, e1 := syscall.Syscall(procRefreshPolicyEx.Addr(), 2, uintptr(_p0), uintptr(flags), 0)
	if int32(r1) == 0 {
		err = errnoErr(e1)
	}
	return
}

func registerGPNotification(event windows.Handle, machine bool) (err error) {
	var _p0 uint32
	if machine {
		_p0 = 1
	}
	r1, _, e1 := syscall.Syscall(procRegisterGPNotification.Addr(), 2, uintptr(event), uintptr(_p0), 0)
	if int32(r1) == 0 {
		err = errnoErr(e1)
	}
	return
}

func unregisterGPNotification(event windows.Handle) (err error) {
	r1, _, e1 := syscall.Syscall(procUnregisterGPNotification.Addr(), 1, uintptr(event), 0, 0)
	if int32(r1) == 0 {
		err = errnoErr(e1)
	}
	return
}
