/*
 * Decompiled with CFR 0.152.
 */
package javaversioncheck;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import javaversioncheck.Version;
import machenv.java.JVCheck;

public class JavaVersionCheck {
    public static void main(String[] args) {
        int retval = 0;
        boolean minSpec = false;
        double reqdMinSpecVer = 0.0;
        JVCheck javaEnv = new JVCheck();
        LongOpt[] longOpts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("minspec", 1, null, 109), new LongOpt("version", 0, null, 86)};
        Getopt g = new Getopt("JavaVersionCheck", args, ":hm:V", longOpts);
        try {
            int c;
            while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 104: {
                        System.out.println("Usage is 'Command' [options]");
                        System.out.println("\t-h or --help displays usage information & exits");
                        System.out.println("\tOR");
                        System.out.println("\t-m or --minspec cf available version against this minimum specification version");
                        System.out.println("\tOR");
                        System.out.println("\t-V or --version displays version information & exits");
                        System.exit(retval);
                    }
                    case 109: {
                        minSpec = true;
                        reqdMinSpecVer = Double.valueOf(g.getOptarg());
                        break;
                    }
                    case 86: {
                        System.out.println("JavaCheckVersion Source version " + Version.getSrcVersion());
                        System.out.println("JavaCheckVersion Package version " + Version.getPkgVersion());
                        System.out.println("libmachenv Source version " + machenv.Version.getSrcVersion());
                        System.out.println("libmachenv Package version " + machenv.Version.getPkgVersion());
                        System.exit(retval);
                    }
                    case 63: {
                        retval = 64;
                        System.exit(retval);
                    }
                }
            }
            if (g.getOptind() < args.length) {
                System.err.println("Invalid argument.");
                retval = 64;
            }
            if (args.length == 0) {
                System.out.println("Installed Java Specification Version is " + javaEnv.getSpecVersion());
            }
            if (minSpec) {
                retval = javaEnv.cmpJavaSpecVersion(reqdMinSpecVer);
            }
        }
        catch (Exception e) {
            System.err.println("Exception : " + e);
            retval = 1;
        }
        System.exit(retval);
    }
}

