---------------------------------
Java Swing AlarmClock Application
=================================

Author - Copyright (C) 2012-2020 Mark Grant

Contents
========

1 ... Project Description

2 ... This Repository

3 ... Project Structure

4 ... Installation

		A) Just using the built jar file.
		B) For systems supporting AutoTools.
		C) Of Distro-Native Package
		D) Windows msi installer.

5 ... Utility Scripts


-------------------------

1 ... Project Description
=========================

This is a GUI AlarmClock application implementing two independent alarms. Each
alarm can be set to 'Alarm At', eg 13:15, or 'Alarm In', eg 1 hour 10 mins.
Each alarm also incorporates a 'Snooze' button that will pause a ringing alarm
for 5 minutes.


---------------------

2 ... This Repository
=====================

AlarmClock is written in Java using NetBeans as an IDE. The project must be
maintained via NetBeans to preserve it's support files, (*.form, build.xml,
etc) which are tracked in git. The repository is also configured for Autotools.
The AutoTools files exist in parallel to the NetBeans files and do not conflict.


-----------------------
3 ... Project Structure
=======================

The NetBeans part of the project is expected to be used for development only.
Once development is complete AutoTools takes over to provide basic build and
packaging which downstream can be turned into debian, rpm etc packages.
AutoTools will build an end-user application consisting of:-

	The main application jar file.
	A bash start-up script.
	A manual page for the start-up script.
	A desktop file for a GUI start-up of the application. (It invokes the
	bash script).


------------------

4 ... Installation
==================

As a Java application it can run on many operating systems.

A.1) Using the NetBeans build output
------------------------------------
The easiest way to use a jar file is to compile and build within NetBeans. This
produces the application in the dist subdirectory. The application can then be
run using:-

	java -jar "dist/AlarmClock.jar"
		with the path modified as necessary.
N.B. If you wish to move the application to another location you *must* move the
relative subdirectory 'lib' with it. i.e. the jar and the lib directory must
maintain their relative relationship.

A.2) Using a tarball of the NetBeans build output
-------------------------------------------------
To simplify the distribution of the jar file and lib directory as mentioned
above, a tarball can be created, distributed, extracted and used.

Create the archive:-

	./credisttar.sh
		with the ./ path modified as necessary.

Distribute the tarball created in project_root/distribution.

Extract the tarball in the desired location:-

	tar xvpzf ./AlarmClockvXXXXXXXXXX.tar.gz
		replacing XXXXXXXXXX with the embedded version string in the
		tarball name.

And then, as above, the application can be run using:-

	java -jar Alarmclock.jar

A.3) Using just the jar from the NetBeans build output
------------------------------------------------------
In order to just use the jar file, the supplemental jar libraries in the
NetBeans dist/lib directory (e.g. getopt) must already be installed on your
system.
Move the jar file to the desired location and run the command:-

	java -cp /usr/share/java/*:./AlarmClock.jar alarmclock.AlarmClock
		with the ./ path modified as necessary.

A.4) Using the jar built by AutoTools
-------------------------------------
In order to use the jar file built by AutoTools, the supplemental jar libraries
(e.g. getopt) must already be installed on your system.
Assuming you are in a build directory one level below project root, build the
project by running:-

	../bootstrap.sh -cba ..
Move the jar to the desired location and run the command:-

	java -cp /usr/share/java/*:./alarmclock-java-x.y.z.jar \
	alarmclock.AlarmClock
	where x.y.z will be the package version number. Modify the ./ path as
	necessary.

B)  AutoTools (configure and make) Installation
-----------------------------------------------
1 ... Download either the source or distribution tarball (the .tar.gz file)
	from:-

https://github.com/m-grant-prg/alarmclock-java/releases

2 ... Extract the tarball preserving the directory structure.

3 ... cd to the directory created.

4 ... If you downloaded the source tarball type 'autoreconf -if'

5(a) ... For Debian and closely related distros where support jar files are
located in /usr/share/java:-

		Type './configure --enable-atonly=yes'
		Now skip to step (6).

5(b) ... For distros which do not store support jar files in /usr/share/java:-

		Find the '/path/to/jars'
		Type './configure STDJARLOC=/path/to/jars --enable-atonly=yes'

6 ... As root or sudo, type 'make install clean'

(Quote marks are for textual clarity only).


To uninstall the package:

1 ... cd to the directory created in the above install process.

2 ... As root or sudo, type 'make uninstall clean'

C) Installation of Distro-Native Package
----------------------------------------
Installation packages native to different distributions are available, please
refer to the relevant installation section on the wiki at:-

https://github.com/m-grant-prg/alarmclock-java/wiki

D) Windows installation
-----------------------
Another associated GitHub repository AlarmClockWindowsDist is available. This
repository provides the mechanism to produce a Windows msi installer package.


---------------------
5 ... Utility Scripts
=====================
In the project root directory there are 2 helper scripts; bootstrap.sh and
credisttar.sh.

bootstrap.sh
------------
This misleadingly named script bootstraps the project build and provides other
useful features. The main options are probably b, c, C, D and T.

In AutoTools it is usually advisable to perform parallel builds. This means you
build somewhere other than the project root. This is because building creates
files and they would confuse the project root downwards. I always create a build
directory straight off the project root, cd to there and do all build and git
work from there, (.gitignore is already set to ignore such a directory).

Assuming you adopt the preceding paragraph then a typical invocation of the
script would be:-

../bootstrap.sh --config --build ..

The last '..' points the way to project root.

For the full list of arguments to bootstrap.sh, please refer to the options
section of the acmbuild wiki, the options are identical:-

https://github.com/m-grant-prg/acmbuild/wiki

credisttar.sh
-------------
This script produces a tarball from the NetBeans build output. The tarball can
then be used for distribution. Both project jar (eg AlarmClock.jar) and
libraries (eg getopt) are archived.

The script always produces the tarball in the project_root/distribution
directory and can be invoked from anywhere, eg:-

../credisttar.sh

