-------------------
Linux Backup System
===================

Author - Copyright (C) 2012-2020 Mark Grant

--------
Contents
========

1 ... Project Description

2 ... AutoTools (configure and make) Installation

3 ... Installation of Distro-Native Packages

4 ... Utility Scripts



-------------------------
1 ... Project Description
=========================

This AutoTools project contains a backup system.

The system can perform 1, 2 or 3 of 4 backup strategies; a full add hoc
backup, a weekly differential or a weekly incremental and a daily selective.
NB Weekly differential and weekly incremental backups are an either / or
situation.

Full ad hoc
-----------
The full ad hoc backup can be used at any time for an independent backup.

Filenames are:- backupYYYYMMDDHHMM.tar.gz

Weekly Differential
-------------------
The weekly differential backup facilitates a full weekly backup and subsequent
daily differential backups, (the differential backups being changes from the
weekly backup - not any previous daily differential backup).

e.g.
Weekly backup performed week 2 of the month on Thursday
Daily differential backup performed on the following Saturday
Daily differential backup performed on the following Monday

In this case the Monday backup holds changes since the Thursday weekly backup.
The above example also shows that you do not have to run the weeklies weekly nor
the dailies daily.

Filenames are:-
	Weekly	backupW.tar.gz	(where W is the week of the month (1 - 5)
	Daily	backupDDD.tar.gz	(eg DDD is Tue)

Weekly Incremental
------------------
The weekly incremental backup facilitates a full weekly backup as in the
differential version but with subsequent daily incremental backups, (the
incremental backups being changes from the preceding backup be it weekly or
daily incremental).

e.g.
Weekly backup performed week 2 of the month on Thursday
Daily incremental backup performed on the following Saturday
Daily incremental backup performed on the following Monday

In this case the Monday backup holds changes since the Saturday daily
incremental backup.
Unlike the daily differential case it is important that daily incremental
backups are not overwritten without an intervening weekly backup. eg Looking at
the above example, if no further backups are taken until the next Saturday and a
daily incremental is run, this will overwrite the first Saturday and would
destroy the chain from the Thursday weekly backup, there would be a gap in the
archive.

Filenames are:-
	Weekly	backupW.tar.gz	(where W is the week of the month (1 - 5)
	Daily	backupDDD.tar.gz	(eg DDD is Tue)

Daily Selective
---------------
The daily selective backups archive a user-specified ,(in a config file), set of
files or directories which are overwritten on a weekly basis.

The system allows for the target device to be either a cifs or NFS share and
this is defined using the setup.sh script. The system supplies scripts for
mounting and unmounting these shares.

Running the Backups
-------------------
Although the commands can all be run manually, it would be more normal to run
them via cron.

e.g. root's crontab might look like:-
# Daily at 17:10 run a selective backup
10 17 * * 0,1,2,3,4,5,6 netbckup -s

# Every Friday, at 00:15, run a full weekly backup
15 00 * * 5 netbckup -w

# Nightly except for Friday, at 00:15, run a daily differential backup
15 00 * * 0,1,2,3,4,6 netbckup -d

In this example the selective backup could be the home directories for all
users.

Shares
------
CIFS and NFS shares are supported. Typically CIFS would be used for Network
Attached Storage (NAS) and NFS would be used to a server.

Three scripts are supplied to manage the shares:-
attbckshare - mount the backups share
chkbckshare - check if the backup share is mounted
detbckshare - unmount the backup share

Restores
--------
So many restore possibilities exist that no restore script is supplied, the user
must follow the general process of:-

attbckshare
Restore files using tar
detbckshare

Config Files
------------
backups.conf - The main configuration file populated by setup.sh

bcksystem.exclude - A file supplied in this project package containing files and
directories to be excluded by all backups. It typically contains directories
such as /proc and /sys. This file must *NOT* be edited, it will be overwritten
by subsequent package updates. Use the other .exclude files supplied.

bckweekly.exclude - Files and directories, (in addition to those specified in
bcksystem.exclude), to be excluded from full weekly backups.

bckdaily.exclude - As for bckweekly.exclude but for daily differential /
incremental backups.

bckseldaily.files - File and directories to be included in the daily selective
backups.

bckseldaily.exclude - As for bckweekly.exclude but for the daily selective
backups.

Logs
----
A log called lixbackups.log in /var/log contains a log of backup runs.
A file is placed in the logrotate.d directory to manage these log files.

N.B.
----
At a source modification / development level, this project expects to reside in
a git environment. This manifests itself in 2 places:-
1) ... .gitignore files are included in the source.
2) ... The make target, 'srctarball', relies on the command 'git archive' so it
	will fail if git is not installed or it is not in a git repository.


-------------------------------------------------
2 ... AutoTools (configure and make) Installation
=================================================

a) ... Download either the source or distribution tarball (the .tar.gz file)
	from:-

https://github.com/m-grant-prg/lixbackups/releases

b) ... Extract the tarball preserving the directory structure.

c) ... cd to the directory created.

d) ... If you downloaded the source tarball type 'autoreconf -if'

e) ... Type './configure'

f) ... As root or sudo, type 'make install clean'

g) ... Shares must be set up as needed.

h) ... After only the initial installation run setup.sh from the pkglibexec
	directory. To find the script location on your system
	type 'find / -path */lixbackups/setup.sh 2>/dev/null'.
	Typically in an AutoTools build pkglibexec is /usr/local/libexec/PACKAGE
	so as root or sudo you would type
	'/usr/local/libexec/lixbackups/setup.sh'.
	Answer the prompts from the setup script.
	Subsequent to the initial installation, config files can only be
	modified with an editor, setup.sh will not work.

i) ... Edit the .files and .exclude files as required.

(Quote marks are for textual clarity only).

To uninstall the package:

1 ... cd to the directory created in the above install process.

2 ... As root or sudo, type 'make uninstall clean'


--------------------------------------------
3 ... Installation of Distro-Native Packages
============================================
Installation packages native to different distributions are available, please
refer to the relevant installation section on the wiki at:-

https://github.com/m-grant-prg/lixbackups/wiki


---------------------
4 ... Utility Scripts
=====================
In the project root directory there is 1 helper script; bootstrap.sh.

bootstrap.sh
------------
This misleadingly named script bootstraps the project build and provides other
useful features. The main options below are probably b, c, C, D and T.

In AutoTools it is usually advisable to perform parallel builds. This means you
build somewhere other than the project root. This is because building creates
files and they would confuse the project root downwards. I always create a build
directory straight off the project root, cd to there and do all build and git
work from there, (.gitignore is already set to ignore such a directory).

Assuming you adopt the preceding paragraph then a typical invocation of the
script would be:-

../bootstrap.sh --config --build ..

The last '..' points the way to project root.

For the full list of arguments to bootstrap.sh, please refer to the options
section of the acmbuild wiki, the options are identical:-

https://github.com/m-grant-prg/acmbuild/wiki

