------------------------------------
Server Wait On Clients (SWOC) System
====================================

Author - Copyright (C) 2018-2021 Mark Grant

--------
Contents
========

1 ... Project Description

2 ... AutoTools (configure and make) Installation

3 ... Installation of Distro-Native Packages

4 ... Utility Scripts



-------------------------
1 ... Project Description
=========================

System Synopsis
---------------
The Server Wait On Clients (SWOC) system provides a mechanism for clients to
register locks on a server which the server can then watch and wait until all
locks are released before taking some action.

It is easier to show an example:
Overnight, clients want to perform crontab work as a user and root, then do a
backup and then shutdown enabling the server to initiate its own shutdown.

So an example root crontab on the client:-
# This line adds a lock, performs some work of unknown duration and releases the
# lock.
10 00 * * 0,1,2,3,4,5,6 date ; swocclient -l ; apt-get update -qq ; \
apt-get upgrade -d -q -y ; apt-get dist-upgrade -d -q -y ; swocclient -r ; date

# This line adds a lock of its own, waits until this client has one lock
# outstanding, ie its own, then performs a backup, releases the lock and shuts
# down.
15 00 * * 0,1,2,3,4,6 date ; swocclient -l ; swocclient -w1 ; date ; \
netbckup -d ; swocclient -r ; date ; at -f shutdown now

At the same time, a user crontab on the client is using two crontab entries to
run some jobs each taking its own lock at the start and releasing it at the
end. Both of these lines are of unknown and variable duration:-
10 00 * * 0,1,2,3,4,6 swocclient -l ; \
get_iplayer --pvr 2>/home/mgrant/Videos/iPlayer/VideosErr.log ; date ; \
swocclient -r

10 00 * * 0,1,2,3,4,6 swocclient -l ; \
mget --quiet --sourcefile /home/mgrant/Downloads/MultiGetSource.txt \
--targetdir /home/mgrant/Downloads ; date ; swocclient -r

Meanwhile on the server, it waits until it has no more registered locks and then
initiates a shutdown.
20 00 * * 0,1,2,3,4,5,6 date ; swocserver -w ; date ; at -f shutdown now

This Project
------------
This AutoTools project contains the swocserver Server Wait On Clients Server
Programs.

This comprises of the command line program swocserver.

If you are going to build this swocserver SWOC Server Programs then you must
install the development files from libswocserver-dev. Other required
dependencies not installed on your system will be identified by the configure
script. Any of these produced by this author can be found in a repository
located here:-
https://github.com/m-grant-prg

Related packages in this system are the dev and lib packages for libswoccommon
SWOC Common Library, equivalent packages for the libswocserver Server Library,
equivalent packages for the libswocclient Client Library, a package swocclient
for the client application, a package swocserver for the server application and
a documentation project swocdoc. There is also a parent project, swoc-full.

So please refer also to the README files of these projects.

N.B.
----
At a source modification / development level, this project expects to reside in
a git environment. This manifests itself in 2 places:-
1) ... .gitignore files are included in the source.
2) ... The make target, 'srctarball', relies on the command 'git archive' so it
	will fail if git is not installed or it is not in a git repository.


-------------------------------------------------
2 ... AutoTools (configure and make) Installation
=================================================

a) ... Download either the source or distribution tarball (the .tar.gz file)
	from:-
	https://github.com/m-grant-prg/swoc/releases

b) ... Extract the tarball preserving the directory structure.

c) ... cd to the directory created.

d) ... If you downloaded the source tarball type 'autoreconf -if'

e) ... Documents can be registered with scrollkeeper but this process will
	conflict if the documents have already been installed via a package
	manager. So, if the documents have not been installed by a package
	manager:-

	Type './configure --enable-atonly'

	and if they have been installed via a package manager:-

	Type './configure'

f) ... As root or sudo, type 'make install clean'

g) ... Edit the sysconfdir/swocserverd.conf, (usually /etc/swocserverd.conf), as
	required.

h) ... Update shared libraries links and cache

	As root or sudo, type 'ldconfig'

(Quote marks are for textual clarity only).

To uninstall the package:

1 ... cd to the directory created in the above install process.

2 ... As root or sudo, type 'make uninstall clean'

3 ... As root or sudo, type 'ldconfig'


--------------------------------------------
3 ... Installation of Distro-Native Packages
============================================
Installation packages native to different distributions are available, please
refer to the relevant installation section on the wiki at:-

https://github.com/m-grant-prg/swoc/wiki


---------------------
4 ... Utility Scripts
=====================
In the project root directory there are 2 helper scripts; bootstrap.sh and
gen-gnulib.sh.

bootstrap.sh
------------
This misleadingly named script bootstraps the project build and provides other
useful features. The main options are probably b, c, C, D and T.

In AutoTools it is usually advisable to perform parallel builds. This means you
build somewhere other than the project root. This is because building creates
files and they would confuse the project root downwards. I always create a build
directory straight off the project root, cd to there and do all build and git
work from there, (.gitignore is already set to ignore such a directory).

Assuming you adopt the preceding paragraph then a typical invocation of the
script would be:-

../bootstrap.sh --config --build ..

The last '..' points the way to project root.

For the full list of arguments to bootstrap.sh, please refer to the options
section of the acmbuild wiki, the options are identical:-

https://github.com/m-grant-prg/acmbuild/wiki


gen-gnulib.sh
-------------
This script generates or re-generates the gnulib requirements, I shan't go into
detail here.

It is useful when setting up the project initially, when you are actually
building in what is required and thinking about it, thereafter it is best to use
../bootstrap.sh --gnulib ..
as it determines whether to do a re-generate based on whether the cache file
exists, i.e. it has been wanted before.

setup.sh
--------
If the sysconfdir/swocserverd.conf configuration file is deleted, or, if
corrupted then delete it, and run setup.sh from the pkglibexec directory. To
find the script location on your system:-
	type 'find / -path */swocserver/setup.sh 2>/dev/null'.
Typically in an AutoTools build pkglibexec is /usr/local/libexec/PACKAGE
so as root or sudo you would type:-
	'/usr/local/libexec/swocserver/setup.sh'.
Answer the prompts from the setup script.
Subsequent to running this script, config files can only be modified with an
editor, setup.sh will not work unless the config file is deleted.

