-----------------------------------
AutoConf and AutoMake Build Scripts
===================================

Author - Copyright (C) 2014-2021 Mark Grant

--------
Contents
========

1 ... Project Description

2 ... AutoTools (configure and make) Installation

3 ... Installation of Distro-Native Packages

4 ... Utility Scripts



-------------------------
1 ... Project Description
=========================

This project produces a helper script for AutoTools projects. It has two main
goals; to reduce repetitive typing of some AutoTools commands, and, to afford a
more standard interface for the programmer across AutoTools projects.


Design
------
At the command line level the script offers it's own options and provides that
all other arguments are passed unparsed and untouched straight to the configure
command line. For example:-

	acmbuild.sh --config .. sysconfdir=/etc -- --prefix=/usr

In this case --config is an acmbuild.sh option to configure the project, .. is
the base directory and everything else is passed untouched to configure,
invoking:-

	../configure sysconfdir=/etc --prefix=/usr

thereby obviously supporting environment variable setting and option passing for
configure.

The acmbuild.sh options come in two flavours; action options and enabling
options.

b, c, C, D, g, K, m and T are action options. -b, for instance will run make,
whereas -D will run make dist.

The rest, (apart from help and version), are enabling options. Invariably these
are implemented merely by passing an enable argument to configure. For example

	acmbuild.sh --config --debug ..

will run

	configure --enable-debug=yes

That is all. For it to be meaningful the developer must process this argument
in configure. The script does not know if the option is sensible, or indeed, if
it is supported by configure, so, in the above example, if the developer had not
written code in configure to process this argument, configure will issue a
warning and then just ignore the option.

As an example of the simplification this script affords, the following
acmbuild.sh command

	acmbuild.sh -cb .

will run

	autoreconf -if .
	./configure (plus options)
	make (plus options)


Implementation
--------------
The project functionality is implemented as two scripts; acmbuild.sh and
bootstrap.sh. acmbuild.sh does nothing more than invoke bootstrap.sh with the
same arguments. This means that all the functionality is in bootstrap.sh. On
project install both scripts are installed but only acmbuild.sh is installed in
the PATH. So all usage is via acmbuild.sh. The reason for this is that it
enables a secondary usage of bootstrap.sh. bootstrap.sh can be copied and pasted
into the project-root of all AutoTools project to provide a simplified and
standardised build bootstrap as is generally recommended. This eliminates any
possible confusion as to which version of bootstrap.sh is being used whilst also
obviating any dependency on this project.


Options
-------
The script offers the following options:-

	-a, --at-only
		during testing and for an AutoTools-only install, some build
		changes are required. e.g. You may reference an external Java
		jar in datadir but in AT builds and installations this may
		expand to /usr/local/share... So a substitution is required for
		this scenario.

	-b, --build
		make the project.

	-c, --config
		configure the project.

	-C, --distcheck
		perform a normal make distcheck.

	-d, --debug
		build with appropriate debug flags.

	-D, --dist
		perform a make dist.

	-g, --gnulib
		run gnulib-tool --update. Checks for the existence of the cache
		file proj-root/m4/gnulib-cache.m4. If it does not exist the
		update is not run.

	-h, --help
		prints usage information.

	-H, --header-check
		show include stack depth

	-K, --check
		run make check

	-m or --menu-config Invoke menu of configurable options

	-p[X] or --parallel-jobs[=X] number of jobs to pass to make as --jobs=
		If not specified make is sequential
		If no value X is given then defaults to nproc

	-s, --sparse
		pass --enable-sparse=yes to configure.

	-t, --testing-hacks
		some build changes may be required for testing purposes. e.g. A
		script may invoke a project jar file which when installed will
		be somewhere under datadir, but during testing it is in the
		project tree.

	-T, --source-tarball
		perform a make srctarball to build a source tarball.

	-v, --verbose
		emit extra information

	-V, --version
		prints version information

Options b build, C distcheck, D dist and T source-tarball are mutually
exclusive.

Options a at-only, d debug, H header-check, s sparse, t testing-hacks and v
verbose  are enabled by configure so require option c config.

N.B.
----
At a source modification / development level, this project expects to reside in
a git environment. This manifests itself in 2 places:-
1) ... .gitignore files are included in the source.
2) ... The make target, 'srctarball', relies on the command 'git archive' so it
will fail if git is not installed or it is not in a git repository.


-------------------------------------------------
2 ... AutoTools (configure and make) Installation
=================================================

a) ... Download either the source or distribution tarball (the .tar.gz file)
	from:-

https://github.com/m-grant-prg/acmbuild/releases

b) ... Extract the tarball preserving the directory structure.

c) ... cd to the directory created.

d) ... If you downloaded the source tarball type 'autoreconf -if'

e) ... Type './configure'

f) ... As root or sudo, type 'make install clean'

(Quote marks are for textual clarity only).


To uninstall the package:

1 ... cd to the directory created in the above install process.

2 ... As root or sudo, type 'make uninstall clean'


--------------------------------------------
3 ... Installation of Distro-Native Packages
============================================
Installation packages native to different distributions are available, please
refer to the relevant installation section on the wiki at:-

https://github.com/m-grant-prg/acmbuild/wiki


---------------------
4 ... Utility Scripts
=====================
In the project root directory there is 1 helper script; bootstrap.sh.

bootstrap.sh
------------
This misleadingly named script bootstraps the project build and provides other
useful features. The main script options are probably b, c, C, D and T.

In AutoTools it is usually advisable to perform parallel builds. This means you
build somewhere other than the project root. This is because building creates
files and they would confuse the project root downwards. I always create a build
directory straight off the project root, cd to there and do all build and git
work from there, (.gitignore is already set to ignore such a directory).

Assuming you adopt the preceding paragraph then a typical invocation of the
script would be:-

../bootstrap.sh --config --build ..

The last '..' points the way to project root.

For the full list of arguments to bootstrap.sh please look at the acmbuild.sh
options section above.

