/*
 * Class ID: AlarmClockHelpAboutJDialog
 * Copyright (C) 2014-2018, 2020, 2021  Mark Grant
 *
 * Released under the GPLv3 only.
 * SPDX-License-Identifier: GPL-3.0-only
 *
 */

/* **********************************************************************
 *									*
 * Changelog								*
 *									*
 * Date		Author	Version	Description				*
 *									*
 * 09/12/2015	MG	1.0.3	Introduced in-source ChangeLogs.	*
 * 10/12/2015   MG	1.0.4   Change to use version information from	*
 *				the Version Class rather than from the	*
 *				static text file.			*
 * 22/01/2020	MG	1.0.5	Correct in-jar resource locations and	*
 *				add getClassLoader to access resource.	*
 * 29/11/2021	MG	1.0.6	Tighten SPDX tag.			*
 *									*
 ************************************************************************
 */

package alarmclock;

import java.awt.image.BufferedImage;
import java.io.*;
import javax.imageio.ImageIO;

/**
 * Class to display a Help | About Swing modal dialog form.
 * @author Mark Grant
 * @version 1.0.6
 */
public class AlarmClockHelpAboutJDialog extends javax.swing.JDialog {

	public BufferedImage alarmClockImage;

	/**
	 * Creates new form AlarmClockHelpAboutJDialog
	 * @param parent The parent frame.
	 * @param modal Modal behaviour true / false.
	 */
	public AlarmClockHelpAboutJDialog(java.awt.Frame parent, boolean modal) {
		super(parent, modal);

		// Initialise icon for use in frame borders etc..
		try {
			alarmClockImage = ImageIO.read(this.getClass().getClassLoader()
				.getResource("jarobjects/AlarmClock.png"));
		}
		catch (Exception e) { }

		initComponents();
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
        // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
        private void initComponents() {

                helpAboutjScrollPane = new javax.swing.JScrollPane();
                helpAboutjTextArea = new javax.swing.JTextArea();
                OKjButton = new javax.swing.JButton();
                srcVersionjLabel = new javax.swing.JLabel();
                srcVersionjTextField = new javax.swing.JTextField();
                pkgVersionjLabel = new javax.swing.JLabel();
                pkgVersionjTextField = new javax.swing.JTextField();

                setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
                setTitle("About AlarmClock");
                setIconImage(null);
                setModal(true);
                setName("AlarmClockHelpAboutJDialog"); // NOI18N
                addWindowListener(new java.awt.event.WindowAdapter() {
                        public void windowOpened(java.awt.event.WindowEvent evt) {
                                formWindowOpened(evt);
                        }
                });

                helpAboutjTextArea.setEditable(false);
                helpAboutjTextArea.setColumns(20);
                helpAboutjTextArea.setRows(5);
                helpAboutjScrollPane.setViewportView(helpAboutjTextArea);

                OKjButton.setText("OK");
                OKjButton.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                OKjButtonActionPerformed(evt);
                        }
                });

                srcVersionjLabel.setText("Java Source Version :");
                srcVersionjLabel.setToolTipText("");

                srcVersionjTextField.setEditable(false);
                srcVersionjTextField.setText("jTextField1");
                srcVersionjTextField.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));

                pkgVersionjLabel.setText("Java Package Version :");

                pkgVersionjTextField.setEditable(false);
                pkgVersionjTextField.setText("jTextField1");
                pkgVersionjTextField.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));

                javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
                getContentPane().setLayout(layout);
                layout.setHorizontalGroup(
                        layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addContainerGap(38, Short.MAX_VALUE)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addGroup(layout.createSequentialGroup()
                                                .addGap(206, 206, 206)
                                                .addComponent(OKjButton))
                                        .addComponent(helpAboutjScrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, 474, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addGroup(layout.createSequentialGroup()
                                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                        .addComponent(srcVersionjLabel)
                                                        .addComponent(pkgVersionjLabel))
                                                .addGap(26, 26, 26)
                                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                        .addComponent(pkgVersionjTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                        .addComponent(srcVersionjTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                                .addContainerGap(26, Short.MAX_VALUE))
                );
                layout.setVerticalGroup(
                        layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addGap(32, 32, 32)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(srcVersionjLabel)
                                        .addComponent(srcVersionjTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 8, Short.MAX_VALUE)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(pkgVersionjLabel)
                                        .addComponent(pkgVersionjTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGap(18, 18, 18)
                                .addComponent(helpAboutjScrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, 244, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(36, 36, 36)
                                .addComponent(OKjButton)
                                .addContainerGap())
                );

                pack();
        }// </editor-fold>//GEN-END:initComponents

	/**
	 * Event handler to close the form when the OK button is actioned.
	 * @param evt Event object.
	 */
	private void OKjButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_OKjButtonActionPerformed
		dispose();
	}//GEN-LAST:event_OKjButtonActionPerformed

	/**
	 * Event handler when window opened. Retrieve & display Help | About details.
	 * @param evt Event object.
	 */
	private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
		this.srcVersionjTextField.setText(Version.getSrcVersion());
		this.pkgVersionjTextField.setText(Version.getPkgVersion());

		int fileByte;
		String text = "";

		try(InputStream fis = this.getClass().getClassLoader()
			.getResourceAsStream("jarobjects/AlarmClockAbout.txt")) {
			do {
				fileByte = fis.read();
				if (fileByte != -1) text += (char) fileByte;
			} while (fileByte != -1);
			this.helpAboutjTextArea.setText(text);
			this.helpAboutjTextArea.setCaretPosition(0);
		}
		catch (Exception e) { }
	}//GEN-LAST:event_formWindowOpened

	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		/*
		 * Set the Nimbus look and feel
		 */
		//<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
		/*
		 * If Nimbus (introduced in Java SE 6) is not available, stay with the
		 * default look and feel. For details see
		 * http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html
		 */
		try {
			for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
				if ("Nimbus".equals(info.getName())) {
					javax.swing.UIManager.setLookAndFeel(info.getClassName());
					break;
				}
			}
		} catch (ClassNotFoundException ex) {
			java.util.logging.Logger.getLogger(AlarmClockHelpAboutJDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
		} catch (InstantiationException ex) {
			java.util.logging.Logger.getLogger(AlarmClockHelpAboutJDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
		} catch (IllegalAccessException ex) {
			java.util.logging.Logger.getLogger(AlarmClockHelpAboutJDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
		} catch (javax.swing.UnsupportedLookAndFeelException ex) {
			java.util.logging.Logger.getLogger(AlarmClockHelpAboutJDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
		}
		//</editor-fold>

		/*
		 * Create and display the dialog
		 */
		java.awt.EventQueue.invokeLater(new Runnable() {

			public void run() {
				AlarmClockHelpAboutJDialog dialog = new AlarmClockHelpAboutJDialog(new javax.swing.JFrame(), true);
				dialog.addWindowListener(new java.awt.event.WindowAdapter() {

					@Override
					public void windowClosing(java.awt.event.WindowEvent e) {
						System.exit(0);
					}
				});
				dialog.setVisible(true);
			}
		});
	}
        // Variables declaration - do not modify//GEN-BEGIN:variables
        private javax.swing.JButton OKjButton;
        private javax.swing.JScrollPane helpAboutjScrollPane;
        private javax.swing.JTextArea helpAboutjTextArea;
        private javax.swing.JLabel pkgVersionjLabel;
        private javax.swing.JTextField pkgVersionjTextField;
        private javax.swing.JLabel srcVersionjLabel;
        private javax.swing.JTextField srcVersionjTextField;
        // End of variables declaration//GEN-END:variables
}
