----------------------------
DNSMASQ Log Rotation Project
============================

Author - Copyright (C) 2018-2020 Mark Grant

--------
Contents
========

1 ... Project Description

2 ... AutoTools (configure and make) Installation

3 ... Installation of Distro-Native Packages

4 ... Utility Scripts



-------------------------
1 ... Project Description
=========================

This AutoTools project utilises the logrotate facility to provide log rotation
for dnsmasq.

It places a logrotate control file in sysconfdir/logrotate.d and a post-rotate
script file in sbindir.


Overview
--------
The dnsmasq-postrotate.sh script has two functions; a setup function and a post-rotate function.

Running dnsmasq-postrotate.sh with the --setup option interrogates the dnsmasq configuration and command line to locate the log file and write this location in the logrotate control file. This is run during the package installation and should be run after configuration changes to dnsmasq.

In normal day-to-day operation after logrotate has rotated the log file dnsmasq-postrotate.sh is run with the --post-rotate option whereby SIGUSR1 and SIGUSR2 are sent to dnsmasq to ask it to dump stats to the log file and to close and reopen it's log file.

During setup the script must determine the log file location and during post-rotate the script must determine the dnsmasq pid file. The two file locations can be specified to dnsmasq with the log-facility and pid-file options. These can be provided via a configuration file or on the command line. Configuration files can be nested via the conf-file and / or conf-dir options. The logic for finding these directives is as follows:-

	a)	Configuration files are processed sequentially and in the
		order they are found.

	b)	The first instance of each directive found is used, in
		fact processing of configuration files terminates
		immediately if both directives are found.

	c)	The first configuration file is either the default,
		sysconfdir/dnsmasq.conf, or if the commmand line contains
		the option -C then the filename specified there is used.

	d)	Any configuration files specified by conf-file, or found
		in a conf-dir directory are appended to the list of
		configuration files to process in the order in which they
		are found.

	e)	If not found in any configuration file then any command
		line specification of these options is used in place of
		the missing directive. (Configuration file value
		overriding command line option is behaviour specified in
		the dnsmasq man page).

	f)	If no pid file is found then as a last resort the pid of
		the running dnsmasq instance is determined and used.

N.B.
----
At a source modification / development level, this project expects to reside in
a git environment. This manifests itself in 2 places:-
1) ... .gitignore files are included in the source.
2) ... The make target, 'srctarball', relies on the command 'git archive' so it
	will fail if git is not installed or it is not in a git repository.


-------------------------------------------------
2 ... AutoTools (configure and make) Installation
=================================================

a) ... Download either the source or distribution tarball (the .tar.gz file)
	from:-

https://github.com/m-grant-prg/dnsmasq-logrotate/releases

b) ... Extract the tarball preserving the directory structure.

c) ... cd to the directory created.

d) ... If you downloaded the source tarball type 'autoreconf -if'

e) ... If your dnsmasq.conf file and logrotate.d directory are where AutoTools
can find them then type

	'./configure'

OR, as is more likely:-

You want to find these files in their standard GNU/Linux locations then type

	'./configure sysconfdir=/etc localstatedir=/var'

f) ... As root or sudo, type 'make install clean'

g) ... As root or sudo, type 'dnsmasq-postrotate.sh --setup'

(Quote marks are for textual clarity only).

To uninstall the package:

1 ... cd to the directory created in the above install process.

2 ... As root or sudo, type 'make uninstall clean'


--------------------------------------------
3 ... Installation of Distro-Native Packages
============================================
Installation packages native to different distributions are available, please
refer to the relevant installation section on the wiki at:-

https://github.com/m-grant-prg/dnsmasq-logrotate/wiki


---------------------
4 ... Utility Scripts
=====================
In the project root directory there is 1 helper script; bootstrap.sh.

bootstrap.sh
------------
This misleadingly named script bootstraps the project build and provides other
useful features. The main options below are probably b, c, C, D and T.

In AutoTools it is usually advisable to perform parallel builds. This means you
build somewhere other than the project root. This is because building creates
files and they would confuse the project root downwards. I always create a build
directory straight off the project root, cd to there and do all build and git
work from there, (.gitignore is already set to ignore such a directory).

Assuming you adopt the preceding paragraph then a typical invocation of the
script would be:-

../bootstrap.sh --config --build ..

The last '..' points the way to project root.

For the full list of arguments to bootstrap.sh, please refer to the options
section of the acmbuild wiki, the options are identical:-

https://github.com/m-grant-prg/acmbuild/wiki

