"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
"									"
" File ID: ./.local.vimrc						"
" Author: Copyright (C) 2021-2023  Mark Grant				"
"									"
" This file is maintained in the project at:-				"
"	https://github.com/m-grant-prg/project-misc			"
"		new versions are merely copied to consumer projects.	"
"									"
" Released under the GPLv3 only.					"
" SPDX-License-Identifier: GPL-3.0					"
"									"
" Purpose:								"
" This file works in conjunction with the vim-localrc plugin.		"
" The file should be placed in the project root directory, i.e. where	"
" the .git directory exists. The plugin then, for any file edited in	"
" that project tree, will look higher in the directory hierarchy until	"
" this file is found, and then it will be processed.			"
"									"
" Defaults And Examples:						"
" Whitespace settings. Values below are the vim defaults.		"
" setlocal tabstop=8		Tab width is set to 8. It is still a \t	"
" setlocal shiftwidth=8		Indents will have a width of 8		"
" setlocal softtabstop=0	Switch off mix tabs and spaces to value	"
" setlocal noexpandtab		Do not expand tabs to spaces.		"
" Changes to these values may best be done by FileType. Example below.	"
" autocmd FileType python setlocal ts=4 sts=0 sw=4 et			"
"									"
" Project Targets:							"
" My C projects. (Covers bash, AutoTools files etc.. in the project).	"
"									"
"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""

"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
"									"
" Changelog								"
"									"
" Date		Author	Version	Description				"
"									"
" 03/11/2021	MG	1.0.1	Initial release.			"
" 24/03/2022	MG	1.0.2	Segregate line and visual, block and	"
"				entire buffer commands for clang-format."
" 23/02/2023	MG	1.0.3	Add a comment that this file is		"
"				maintained in another project.		"
"									"
"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""

" Setup clang-format.
" -------------------
" Current line / Visual block.
imap <C-K> :py3f /usr/share/vim/addons/syntax/clang-format.py<cr>
nmap <C-K> :py3f /usr/share/vim/addons/syntax/clang-format.py<cr>
vmap <C-K> :py3f /usr/share/vim/addons/syntax/clang-format.py<cr>
" Current block.
nmap <C-K><C-K> [{V]}:py3f /usr/share/vim/addons/syntax/clang-format.py<cr>''
" Entire buffer
nmap <C-K><C-K><C-K> ggVG:py3f /usr/share/vim/addons/syntax/clang-format.py<cr>''

