----------------------------
MGE System Utilities Library
============================

Author - Copyright (C) 2017-2022 Mark Grant

--------
Contents
========

1 ... Project Description

2 ... AutoTools (configure and make) Installation

3 ... Installation of Distro-Native Packages

4 ... Utility Scripts

5 ... Further Information



-------------------------
1 ... Project Description
=========================

This AutoTools project contains the libmgesysutils MGE System Utilities Library.

Notable function subjects include:-
Config file parsing.
Send a remote syslog entry.

If you are going to build, or build against, this libmgesysutils MGE System
Utilities Library then you must install the development files from
libmgesysutils-dev.

Related packages are the libmgesysutils-dev MGE System Utilities Library
Development Files, an API documentation package libmgesysutils-doc and a full
documentation package libmgesysutils-int-doc. These Doxygen documentation
packages are also available online at -
https://m-grant-prg.github.io/libmgesysutils/


N.B.
----
At a source modification / development level, this project expects to reside in
a git environment. This manifests itself in 2 places:-
1) ... .gitignore files are included in the source.
2) ... The make target, 'srctarball', relies on the command 'git archive' so it
	will fail if git is not installed or it is not in a git repository.


-------------------------------------------------
2 ... AutoTools (configure and make) Installation
=================================================

a) ... Download either the source or distribution tarball (the .tar.gz file)
	from:-
	https://github.com/m-grant-prg/libmgesysutils/releases

b) ... Extract the tarball preserving the directory structure.

c) ... cd to the directory created.

d) ... If you downloaded the source tarball type 'autoreconf -if'

e) ... Documents can be registered with scrollkeeper but this process will
	conflict if the documents have already been installed via a package
	manager. So, if the documents have not been installed by a package
	manager:-

	Type './configure --enable-atonly'

	and if they have been installed via a package manager:-

	Type './configure'

f) ... As root or sudo, type 'make install clean'

g) ... Update shared libraries links and cache

	As root or sudo, type 'ldconfig'

(Quote marks are for textual clarity only).

To uninstall the package:

1 ... cd to the directory created in the above install process.

2 ... As root or sudo, type 'make uninstall clean'

3 ... As root or sudo, type 'ldconfig'


--------------------------------------------
3 ... Installation of Distro-Native Packages
============================================
Installation packages native to different distributions are available, please
refer to the relevant installation section on the wiki at:-

https://github.com/m-grant-prg/libmgesysutils/wiki


---------------------
4 ... Utility Scripts
=====================
In the project root directory there are 2 helper scripts; bootstrap.sh and
gen-gnulib.sh.

bootstrap.sh
------------
This misleadingly named script bootstraps the project build and provides other
useful features. The main options are probably b, c, C, D and T.

In AutoTools it is usually advisable to perform parallel builds. This means you
build somewhere other than the project root. This is because building creates
files and they would confuse the project root downwards. I always create a build
directory straight off the project root, cd to there and do all build and git
work from there, (.gitignore is already set to ignore such a directory).

Assuming you adopt the preceding paragraph then a typical invocation of the
script would be:-

../bootstrap.sh --config --build ..

The last '..' points the way to project root.

For the full list of arguments to bootstrap.sh, please refer to the options
section of the acmbuild wiki, the options are identical:-

https://github.com/m-grant-prg/acmbuild/wiki


gen-gnulib.sh
-------------
This script generates or re-generates the gnulib requirements, I shan't go into
detail here.

It is useful when setting up the project initially, when you are actually
building in what is required and thinking about it, thereafter it is best to use
../bootstrap.sh --gnulib ..
as it determines whether to do a re-generate based on whether the cache file
exists, i.e. it has been wanted before.

-------------------------
5 ... Further Information
=========================
Further information can be found on the wiki at:-

https://github.com/m-grant-prg/libmgesysutils/wiki

Programmer oriented documentation can for the latest stable release can be found
at:-

https://m-grant-prg.github.io/libmgesysutils/

The API link will provide documentation relevant to a consumer of the project,
whereas, the internal documentation provides that documentation plus
documentation aimed at contributors to the project.

