---------------------------
mget File Downloader System
===========================

Author - Copyright (C) 2013-2020 Mark Grant

--------
Contents
========

1 ... Project Description

2 ... AutoTools (configure and make) Installation

3 ... Installation of Distro-Native Packages

4 ... Utility Scripts



-------------------------
1 ... Project Description
=========================

This AutoTools project contains a file downloader system.

mget downloads 1 or more files whose URL's are specified in a file whose
filename is given as a command line argument. The downloaded files are placed in
a specified target directory. The source file and target directory can be saved
to a config file and these values will be used in future if values are not
specified on the command line.

If a text file is being downloaded, a conversion to Unix or Windows line endings
can be specified on the command line.

For further information please look at the man page or mget --help.

This script lends itself to being used with cron.

Example
-------
Create a file eg /home/mgrant/Downloads/download-requests.txt

Place the following URL's in it:-
https://www.debian.org/doc/debian-policy/policy.txt
https://www.google.com/intl/en/policies/privacy/google_privacy_policy_en.pdf

Save the file.

Type 'mget -S /home/mgrant/Downloads/download-requests.txt \
	-T /home/mgrant/Downloads \
	--persist'
and check the result.

If you now modify the contents of the request file you could:-
Type 'mget'
and it will use the saved values of source file and target directory.

N.B.
----
At a source modification / development level, this project expects to reside in
a git environment. This manifests itself in 2 places:-
1) ... .gitignore files are included in the source.
2) ... The make target, 'srctarball', relies on the command 'git archive' so it
	will fail if git is not installed or it is not in a git repository.


-------------------------------------------------
2 ... AutoTools (configure and make) Installation
=================================================

a) ... Download either the source or distribution tarball (the .tar.gz file)
	from:-

https://github.com/m-grant-prg/mget/releases

b) ... Extract the tarball preserving the directory structure.

c) ... cd to the directory created.

d) ... If you downloaded the source tarball type 'autoreconf -if'

e) ... Type './configure'

f) ... As root or sudo, type 'make install clean'

(Quote marks are for textual clarity only).

To uninstall the package:

1 ... cd to the directory created in the above install process.

2 ... As root or sudo, type 'make uninstall clean'


--------------------------------------------
3 ... Installation of Distro-Native Packages
============================================
Installation packages native to different distributions are available, please
refer to the relevant installation section on the wiki at:-

https://github.com/m-grant-prg/mget/wiki


---------------------
4 ... Utility Scripts
=====================
In the project root directory there is 1 helper script; bootstrap.sh.

bootstrap.sh
------------
This misleadingly named script bootstraps the project build and provides other
useful features. The main options below are probably b, c, C, D and T.

In AutoTools it is usually advisable to perform parallel builds. This means you
build somewhere other than the project root. This is because building creates
files and they would confuse the project root downwards. I always create a build
directory straight off the project root, cd to there and do all build and git
work from there, (.gitignore is already set to ignore such a directory).

Assuming you adopt the preceding paragraph then a typical invocation of the
script would be:-

../bootstrap.sh --config --build ..

The last '..' points the way to project root.

For the full list of arguments to bootstrap.sh, please refer to the options
section of the acmbuild wiki, the options are identical:-

https://github.com/m-grant-prg/acmbuild/wiki

