----------------------------
Dependency On Server At Boot
============================

Author - Copyright (C) 2018-2020 Mark Grant

--------
Contents
========

1 ... Project Description

2 ... AutoTools (configure and make) Installation

3 ... Installation of Distro-Native Packages

4 ... Utility Scripts



-------------------------
1 ... Project Description
=========================

This project enables you to test whether a server is contactable during boot and
execute a series of commands depending on the outcome. It is probably easiest to
understand from an example.

The Problem
-----------
You have a laptop which when you are in the office needs to automatically mount
some shares from an internal server. When travelling you don't want the laptop
to attempt to automount the shares because that produces boot errors and boot
delays. So a plain auto entry in /etc/fstab is out.

The Solution
------------
Install this project.

Enter the shares in /etc/fstab with the noauto option.

Add the server to the /etc/dosab/server.list file.

Add the mount commands to a file you create called
/etc/dosab/server-name.available. (In this case if the server is unavailable you
just want to do nothing so there is no server-name.unavailable file.

Now, every time you boot the laptop it will mount the shares if the server is
available and otherwise do nothing.

Actual example files are available in the source tree in src/conf/etc and
installed by the project in $docdir (often /usr/share/doc/server-dependency or
/usr/local/share/doc/server-dependency).

N.B.
----
At a source modification / development level, this project expects to reside in
a git environment. This manifests itself in 2 places:-
1) ... .gitignore files are included in the source.
2) ... The make target, 'srctarball', relies on the command 'git archive' so it
	will fail if git is not installed or it is not in a git repository.


-------------------------------------------------
2 ... AutoTools (configure and make) Installation
=================================================

a) ... Download either the source or distribution tarball (the .tar.gz file)
	from:-
	https://github.com/m-grant-prg/server-dependency/releases

b) ... Extract the tarball preserving the directory structure.

c) ... cd to the directory created.

d) ... If you downloaded the source tarball type 'autoreconf -if'

e) ... Type './configure --enable-systemd=yes'

f) ... As root or sudo, type 'make install clean'

g) ... Edit the server.list file to enter the servers to check.

h) ... Create server-name.available and server-name.unavailable files as
	required.

(Quote marks are for textual clarity only).

To uninstall the package:

1 ... cd to the directory created in the above install process.

2 ... As root or sudo, type 'make uninstall clean'


--------------------------------------------
3 ... Installation of Distro-Native Packages
============================================
Installation packages native to different distributions are available, please
refer to the relevant installation section on the wiki at:-

https://github.com/m-grant-prg/server-dependency/wiki


---------------------
4 ... Utility Scripts
=====================
In the project root directory there is 1 helper script; bootstrap.sh.

bootstrap.sh
------------
This misleadingly named script bootstraps the project build and provides other
useful features. The main options are probably b, c, C, D and T.

In AutoTools it is usually advisable to perform parallel builds. This means you
build somewhere other than the project root. This is because building creates
files and they would confuse the project root downwards. I always create a build
directory straight off the project root, cd to there and do all build and git
work from there, (.gitignore is already set to ignore such a directory).

Assuming you adopt the preceding paragraph then a typical invocation of the
script would be:-

../bootstrap.sh --config --build ..

The last '..' points the way to project root.

For the full list of arguments to bootstrap.sh, please refer to the options
section of the acmbuild wiki, the options are identical:-

https://github.com/m-grant-prg/acmbuild/wiki

