#include "dsCommandMessage_c.h"
#include "CommandInsertBlock.h"

bool CommandInsertBlock::ExecuteNotify(void)
{
    // Get DraftSight command line interface
    dsCommandMessage_ptr commandline;
    application->GetCommandMessage( &commandline );

    // Leave, if name is empty. Note: dsString misses and empty() check
    // and an empty dsString has \0, hence its size is 1.
    if (Options::instance().LastBlockName.getSize() == 1)
    {
        commandline->PrintLine(L"Block was not specified.");
        return false;
    }

    // Get the active document to get the model to get the
    // sketch manager in order to insert blocks.
    dsDocument_ptr doc;
    application->GetActiveDocument(&doc);
    dsModel_ptr model;
    doc->GetModel(&model);
    dsSketchManager_ptr sketchmanager;
    model->GetSketchManager(&sketchmanager);

    long count = 0;
    bool result;
    commandline->PromptForInteger( L"How often do you want to insert the two circles block?",
        1, &count, &result );
    for (long i = 0; i < count; ++i)
    {
        // Prompt for block insertion
        dsPromptResultType_e result;
        double x = 0, y = 0, z = 0;
        double scale_x = 1, scale_y = 1, scale_z = 1;
        double rotation = 0;
        commandline->PromptForBlockInsertion(
            Options::instance().LastBlockName,
            true,
            1, 1, 1,
            true,
            0,
            &x, &y, &z,
            &scale_x, &scale_y, &scale_z,
            &rotation,
            &result);
        if (result != dsPromptResultType_Value)
            return false;

        // Insert the block
        dsBlockInstance_ptr block;
        sketchmanager->InsertBlock2(
            Options::instance().LastBlockName,
            x, y, z,
            scale_x, scale_y, scale_z,
            rotation,
            &block); 
    }

    return true; 
}
