#include "dsCommandMessage_c.h"
#include "CommandReadCustomData.h"
#include <sstream>

bool CommandReadCustomData::ExecuteNotify(void)
{
    // Get DraftSight command line interface
    dsCommandMessage_ptr commandline;
    application->GetCommandMessage( &commandline );

    // Get the active document and its selection manager.
    dsDocument_ptr doc;
    application->GetActiveDocument(&doc);
    dsSelectionManager_ptr selectionmanager;
    doc->GetSelectionManager(&selectionmanager);

    // Clear the filter, since it may have
    // been set somewhere else beforehand.
    dsInterfacePtr<dsSelectionFilter_c> filter;
    selectionmanager->GetSelectionFilter(&filter);
    filter->Clear();

    // Prompt for selection, if no entity selected yet.
    bool result;
    commandline->PromptForSelection(
        false, L"Select one or more entities", L"", &result);

    // Get the selected objects
    long selection_set_count;
    selectionmanager->GetSelectedObjectCount(
        dsSelectionSetType_Previous, &selection_set_count);
	std::wostringstream prompt;
	prompt << L"Selected objects: "
           << selection_set_count;
    commandline->PrintLine( prompt.str().c_str() );

    // Iterate over the selected objects
    for (long o = 0; o < selection_set_count; ++o)
    {
        dsObjectType_e type;
        dsObject *object;
        selectionmanager->GetSelectedObject(
            dsSelectionSetType_Previous, o, &type, &object);
		std::wostringstream prompt;
		prompt << L"Object type ="
               << type
			   << L":"
			   << d2s(type);
        commandline->PrintLine( prompt.str().c_str() );

        // Access the current object's custom data.
        dsEntityHelper_ptr helper;
        application->GetEntityHelper(&helper);
        dsCustomData_ptr data;
        helper->GetCustomData(object, L"BlockCustomData", &data);
        long count_custom_data;
        data->GetDataCount(&count_custom_data);
		std::wostringstream promptForEntry;
		promptForEntry << L"Data entries found: "
			   << count_custom_data;
		commandline->PrintLine( promptForEntry.str().c_str() );

        // Iterate over all data and write them on the command line.
        for (long d = 0; d < count_custom_data; ++d)
        {
            dsString s;
            long i;
            double x, y, z;
			std::wostringstream value;
            dsCustomDataType_e datatype;
            data->GetDataType(d, &datatype);
            switch (datatype)
            {
            case dsCustomDataType_Unknown:
                value << L"n/a";
                break;
            case dsCustomDataType_String:
                data->GetStringData(d, &s);
                value << (wchar_t*)s;
                break;
            case dsCustomDataType_Integer16:
                data->GetInteger16Data(d, &i);
                value << i;
                break;
            case dsCustomDataType_Integer32:
                data->GetInteger32Data(d, &i);
                value << i;
                break;
            case dsCustomDataType_Double:
                data->GetDoubleData(d, &x);
                value << x;
                break;
            case dsCustomDataType_Point:
                data->GetPointData(d, &x, &y, &z);
				value << x << L"," << y << L"," << z;
                break;
            case dsCustomDataType_BinaryData:
                value << L"[...]";
                break;
            case dsCustomDataType_LayerName:
                data->GetLayerName(d, &s);
				value << s;
                break;
            case dsCustomDataType_Handle:
                data->GetLayerName(d, &s);
                value << (wchar_t*)s;
                break;
            case dsCustomDataType_CustomData:
                value << L"[...]";
                break;
            default: break;
            }

			std::wostringstream str;
			str << L"Datatype =" << datatype << L":" << d2s(datatype) << L", " << L"value = " << value.str().c_str();
            commandline->PrintLine( str.str().c_str() );

        } // iterate over the current object's custom data
    } // iterate over all selected objects

    return true; 
}
