#include "stdafx.h"
#include "Options.h"
#include "dsAddinConnection.h"

BlockCustomDataApplication *globalBlockCustomData = 0;
const dsString BlockCustomDataApplication::appID = L"57F2A877-375A-434D-8425-A2B5822E98BD";

bool BlockCustomDataApplication::CreateUserInterfaceAndCommands()
{
    // 1 - First register your command here
    //     (for invoking the command from the command line)
    m_CommandCreateNewBlock.createAndRegisterCommand();
    m_CommandInsertBlock.createAndRegisterCommand();
    m_CommandSetCustomData.createAndRegisterCommand();
    m_CommandReadCustomData.createAndRegisterCommand();

    // Menu should be between "Modify" and "Tools" menus
    const int USERMENU_POSITION = 9;

    // Create user menu
    dsMenuItem_ptr menu;
    application->AddMenu(
        BlockCustomDataApplication::appID,
        dsUIState_Document,
        USERMENU_POSITION,
        L"BlockCustomData",
        &menu);
    if (!menu)
        return false;
    dsMenuItem_ptr menu_item;
    long menu_position = 1;

    // Create toolbar
    dsToolbar_ptr toolbar;
    application->AddToolbar(
        BlockCustomDataApplication::appID,
        dsUIState_Document,
        L"BlockCustomData",
        &toolbar);
    if (!toolbar)
        return false;
    dsToolbarItem_ptr toolbar_item;
    long toolbar_position = 1;

    // 2 - Then append your command here, where you see fit in the menu.
    //     You can also create a new menu.

    m_CommandCreateNewBlock.createUserCommand();
    m_CommandCreateNewBlock.insert(menu, menu_position++);
    m_CommandCreateNewBlock.insert(toolbar, toolbar_position++);

    m_CommandInsertBlock.createUserCommand();
    m_CommandInsertBlock.insert(menu, menu_position++);
    m_CommandInsertBlock.insert(toolbar, toolbar_position++);

    m_CommandSetCustomData.createUserCommand();
    m_CommandSetCustomData.insert(menu, menu_position++);
    m_CommandSetCustomData.insert(toolbar, toolbar_position++);

    m_CommandReadCustomData.createUserCommand();
    m_CommandReadCustomData.insert(menu, menu_position++);
    m_CommandReadCustomData.insert(toolbar, toolbar_position++);

    return true;
}

#ifdef DS_WIN
BlockCustomData_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#else //DS_WIN
extern "C" BlockCustomData_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#endif //DS_WIN
{
    if (!globalBlockCustomData)
    {
        Options::instance().application = dsApp;
        Options::instance().ApiUuid = BlockCustomDataApplication::appID;
        globalBlockCustomData = new BlockCustomDataApplication(dsApp);
        return globalBlockCustomData->CreateUserInterfaceAndCommands();
    }
    return false;
}

#ifdef DS_WIN
BlockCustomData_EXPORT bool disconnectFromDraftSight()
#else //DS_WIN
extern "C" BlockCustomData_EXPORT bool disconnectFromDraftSight()
#endif //DS_WIN
{
    if (globalBlockCustomData)
    {
        if (globalBlockCustomData->getDsApp())
        {
            globalBlockCustomData->getDsApp()->RemoveUserInterface(
                BlockCustomDataApplication::appID);
        }

        delete globalBlockCustomData;
        globalBlockCustomData = 0;
    }

    return true;
}

#ifdef DS_WIN
BlockCustomData_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#else //DS_WIN
extern "C" BlockCustomData_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#endif //DS_WIN
{
    *sId1 = dsString( L"BCF5DA83-F204-4a57-A65C-D7D48BB4D37B" );
    return true;
}