#ifndef OPTIONS_H
#define OPTIONS_H

#include <QString>
#include "dsString.h"
#include "dsCustomPropertyControl_c.h"
#include "dsApplication_c.h"

struct OptionsRecord
{
    static const QString DockWidgetName;
    QString library_root_path;
    dsCustomPropertyControl_c *dockwidget;
    dsApplication_c *application;
    dsString ApiUuid;

    OptionsRecord(): dockwidget(0), application(0) {}
};

// This singleton class represents the settings for the BlockLibraryManager
// to operate. It is accessible throughout the add-in. You can access the
// singleton using the static method instance().
class Options : public OptionsRecord
{
public:
    // Get access to the singleton object.
    static Options& instance() {
        static Options o;
        return o;
    }

    // Sets the options to some default settings.
    void setDefault();

protected:
    // The options are singleton.
    Options() { setDefault(); }
};

#endif // OPTIONS_H
