#include <QDir>

#include "dsCommandMessage_c.h"
#include "dsInterfacePtr.h"

#include "../Options.h"
#include "CommandHide.h"

bool CommandHide::ExecuteNotify()
{
    dsCommandMessage_ptr commandline;
    application->GetCommandMessage(&commandline);
 
    // Leave, if the widget does not exist
    if (!Options::instance().dockwidget)
    {
        commandline->PrintLine(q2d(tr(
            "<p style=\"color:#990000;font-weight:bold\">"
            "An embarrassing error occurred: The window does not exist."
            "</p>")));
        return false;
    }

    // Notify, if the library does not exist
    if (!QDir(Options::instance().library_root_path).exists())
    {
        commandline->PrintLine(q2d(tr(
            "<p style=\"color:#990000;font-weight:bold\">"
            "Error: block library root directory missing.<br/>"
            "\"%1\" does not exist."
            "</p>")
            .arg(Options::instance().library_root_path)));
    }

    Options::instance().dockwidget->put_Visible(false);
    return true; 
}
