#ifndef MISCELLANEOUS_H
#define MISCELLANEOUS_H

#include <QString>
#include <QStringList>
#include <QByteArray>
#include <QWidget>

#include "dsString.h"
#include "dsStringArray.h"
#include "dsByteArray.h"

// Sets a system variable:
// set variable=value
int setEnvironmentVariable(
    const QString &variable,
    const QString &value = QString());

// Returns the value of the specified environment variable or an
// empty string if that variable is not set in the environment.
QString getEnvironmentVariable(const QString &variable);

// Converts a QString into a dsString.
dsString q2d(const QString &s);

// Converts a QStringList into a dsStringArray.
dsStringArray q2d(const QStringList &l);

// Converts a QByteArray into a dsByteArray.
dsByteArray q2d(const QByteArray &a);

// Converts a dsString into a QString.
QString d2q(const dsString &s);

// Converts a dsStringArray into a QStringList.
QStringList d2q(const dsStringArray &l);

// Converts a dsByteArray into a QByteArray.
QByteArray d2q(const dsByteArray &a);

#endif // MISCELLANEOUS_H
