#ifndef BlockLibraryWidget_H
#define BlockLibraryWidget_H

#include <list>

#include <QString>
#include <QStringList>
#include <QFileSystemModel>
#include <QWidget>

#include "dsApplication_c.h"

#include "ui_BlockLibraryWidget.h"

class BlockLibraryWidget : public QWidget
{
    Q_OBJECT

public:
    BlockLibraryWidget(QWidget *parent = 0);
    Ui::BlockLibraryWidgetUI ui;

    QStringList getSelectedDrawings() const { return m_selected_drawings; }
    double scaleX() const { return ui.ed_scale_x->text().toDouble(); }
    double scaleY() const { return ui.ed_scale_y->text().toDouble(); }
    double scaleZ() const { return ui.ed_scale_z->text().toDouble(); }
    double rotation() const { return ui.ed_rotation->text().toDouble(); }
    bool specifyScaleLater() const { return ui.ch_scale->isChecked(); }
    bool specifyRotationLater() const { return ui.ch_rotation->isChecked(); }

    // Sets the root directory of the block library.
    void setLibraryRoot(const QString &path);

// The slots are automatically connected due to names convention.
// See also QMetaObject::connectSlotsByName(BlockLibraryWidget);
protected slots:
    // Populates ui.list_drawings with the currently selected directory.
    void on_tree_libraries_clicked(const QModelIndex &index);

    // Populates m_selected_drawings with the currently selected drawings.
    void on_list_drawings_itemSelectionChanged();

    void on_ch_scale_clicked();
    void on_ch_rotation_clicked();

protected:
    dsApplication_c *application;

    // Model for the underlying directory structure
    QFileSystemModel m_library_model;

    // DWG files only
    QStringList m_dwg_filter;

    // This list will be returned via getSelectedDrawings()
    // when the dialog is closed.
    QStringList m_selected_drawings;

    // ui.list_drawings shows all DWGs that are in m_current_directory.
    QString m_current_directory;
};

#endif // BlockLibraryWidget_H
