#include <string>
#include "CommandBase.h"

dsCreateCommandError_e CommandBase::createCommand()
{
    dsCreateCommandError_e error;
    application->CreateCommand2(
        groupName(),
        globalName(),
        localName(),
        &error,
        &m_command);
    return error;
}

void CommandBase::registerCommand()
{
    if (m_command)
        RegisterCommandExecuteNotifyHook(m_command);
}

void CommandBase::unregisterCommand()
{
    if (m_command)
        UnRegisterCommandExecuteNotifyHook(m_command);
}

DSRESULT CommandBase::removeCommand()
{
    if (!m_command)
        return DSRESULT_Disconnected;
    UnRegisterCommandExecuteNotifyHook(m_command);
    DSRESULT result = application->RemoveCommand(m_command);
    delete m_command;
    m_command = 0;
    return result;
}

dsCreateCommandError_e CommandBase::createAndRegisterCommand()
{
    dsCreateCommandError_e error = createCommand();
    registerCommand();
    return error;
}

dsCreateCommandError_e CommandBase::createUserCommand(
    dsUIState_e uiState /*= dsUIState_Document*/)
{
    // Note: Replace this, once dsStrings can be concatenated.
    std::wstring user_command_name(L"^C^C");
    user_command_name += globalName();

    dsCreateCommandError_e error;
    m_user_command_id = L"";
    application->CreateUserCommand(
        groupName(),
        globalName(),
        user_command_name.c_str(),
        Description(),
        SmallIcon(),
        LargeIcon(), 
        uiState,
        &error,
        &m_user_command);
    if (error == dsCreateCommand_Succeeded)
        m_user_command->GetID(&m_user_command_id);
    return error;
}

dsMenuItem_c* CommandBase::insert(dsMenuItem_c *menu, const int &position)
{
    dsMenuItem_c *item = 0;
    menu->InsertMenuItem(
        groupName(),
        dsMenuItemType_UserCommand,
        position,
        ItemName(),
        m_user_command_id,
        &item);
    return item;
}

dsToolbarItem_c* CommandBase::insert(dsToolbar_c *toolbar, const int &position)
{
    dsToolbarItem_c *item = 0;
    toolbar->InsertToolbarItem(
        groupName(),
        dsToolBarItemType_UserCommand,
        position,
        ItemName(),
        m_user_command_id,
        &item);
    return item;
}

ImplementCommandExecuteNotifyHook(CommandBase)
