#ifndef DS_ADDIN_CONNECTION_H
#define DS_ADDIN_CONNECTION_H

/*
Sample Name: ColorPicker

Sample Description:
    This sample opens the Color Picker and make the dialog parent of color picker.

Usage:
    This example has one command, which can be invoked using either the
    command line or by using the menu "OPENCOLORPICKER".
        
    _OPENCOLORPICKER "Open color picker"
        Opens a dialog from where color picker can be open.

Overview:
    Put in a few words, this add-in consists of the following parts:

    Graphical User Interface:
        The class TextInsertionWidget (.h, .cpp, .ui) is the GUI of this
        add-in. It appears as a local variable in CommandDialog::
        ExecuteNotify(), embedded in a modal dialog.

    Functionality:
        Though the actual job is done by the class dsColorPicker,
        our attention is attracted to the following ui:
            - dsColorPicker

        This short class is the widgets, and thus the topic
        which this sample is about. They show how you can use Qt to
        assemble widgets (or controls) for dsAPI add-ins. Please have a
        thorough look there.

    Command classes:
        _OPENCOLORPICKER (class CommandDialog) derives from CommandBase. This base
        class provides an interface for both, registering a command to be
        used from the command line via CommandBase::registerCommand() as
        well as putting a command into a menu item via CommandBase::
        createUserCommand(), so done in PropertyWidgetsApplication::
        CreateUserInterfaceAndCommands().

    Globally available options:
        This singleton Options class holds a globally accessible pointer
        to the application as well as the UUID of this add-in. You can add
        any data that is ought to be available throughout this program.
        
        Furthermore, there is the miscellaneous.h, a collection of useful
        functions for converting between dsAPI and Qt classes. These
        functions are used throughout the add-in.

Notable dsAPI functions used:
        dsApplication_c::GetNamedColor()
        dsApplication_c::CreateColorPicker()
        dsColorPicker_c::GetColor()
*/

#include <QObject>
#include "dsApplication_c.h"
#include "dsInterfacePtr.h"

#include "ColorPicker_global.h"

// You can append new commands like this:
// 1 - Append the header file here.
// 2 - Add the command as a private member of ColorPickerApplication.
// 3 - Go to bool ColorPickerApplication::CreateUserInterfaceAndCommands() and:
//     1 - Register your command using the registerCommand()
//         (then the command can be invoked from the command line).
//     2 - If it makes sense, add it to the user menu
//         (then the command can be invoked from the user menu as well).
#include "commands/CommandDialog.h"        

class ColorPicker_EXPORT ColorPickerApplication : public QObject
{
    Q_OBJECT
public:
    ColorPickerApplication(dsApplication_c *dsApp)
        : QObject(0)
        , m_dsApp(dsApp)
    {}

    dsApplication_c* getDsApp() { return m_dsApp; }  

    // Registers commands to the command line,
    // to the menu and to a toolbar.
    bool CreateUserInterfaceAndCommands();

    static const dsString appID;

private:
    dsApplication_ptr m_dsApp;
    CommandDialog m_CommandDialog;
};

#endif // DS_ADDIN_CONNECTION_H
