#include "Options.h"
#include "dsColorPickerButton.h"
#include "dsColor_c.h"

dsColorPicker::dsColorPicker(QWidget *parent /*= 0*/) : QWidget(parent)
{
	ui.setupUi(this);
	connect(ui.pushButton, SIGNAL(clicked()), SLOT(btnClicked()));
}

void dsColorPicker::btnClicked()
{
	dsExecuteDlgResult_e  ReturnValue;
	Options::instance().application->CreateColorPicker(false, true, &colorPicker);
	colorPicker->SetParent(long(this));
	colorPicker->Execute( &ReturnValue );	

	dsColor_c *m_color;
	if (ReturnValue == dsExecuteDlgResult_Accepted)
	{
         colorPicker->GetColor(&m_color);

		long Red, Green, Blue;
		m_color->GetRGB( &Red, &Green, &Blue);

		ui.label->setAutoFillBackground(true);
		QPalette palette = ui.label->palette();
		palette.setColor(QPalette::Window, QColor((int)Red, (int)Green, (int)Blue));
		ui.label->setPalette(palette);
	}
}
