#include "LispFunctionBase.h"

dsCreateCommandError_e LispFunctionBase::createFunction(dsDocument_c *document)
{
    dsCreateCommandError_e error;
    document->CreateLispFunction(
        groupName(),
        functionName(),
        &error,
        &m_function);
    return error;
}

void LispFunctionBase::registerFunction()
{
    if (m_function)
        RegisterLispFunctionExecuteFunctionNotifyHook(m_function);
}

void LispFunctionBase::unregisterFunction()
{
    if (m_function)
        UnRegisterLispFunctionExecuteFunctionNotifyHook(m_function);
}

DSRESULT LispFunctionBase::removeFunction(dsDocument_c *document)
{
    if (!m_function)
        return DSRESULT_False;
    UnRegisterLispFunctionExecuteFunctionNotifyHook(m_function);
    return document->RemoveLispFunction(functionName());
}

ImplementLispFunctionExecuteFunctionNotifyHook(LispFunctionBase)
