#ifndef COMMANDUNREGISTER_H
#define COMMANDUNREGISTER_H

#include <map>

#include "../LispFunctionBase.h"
#include "../Options.h"
#include "../miscellaneous.h"
#include "../CommandBase.h"

class CommandUnregister : public CommandBase
{
public:
    CommandUnregister(std::map<dsString,LispFunctionBase*> *lisp)
        : CommandBase(Options::instance().application)
        , lisp(lisp)
    {}

    const dsString groupName() const { return Options::instance().ApiUuid; }
    const dsString globalName() const { return L"_LSUNREGISTER"; }
    const dsString localName() const { return L"LSUNREGISTER"; }
    const dsString Description() const { return L"Unregisters one or all of this sample's Lisp functions"; }
    const dsString ItemName() const { return L"Unregister Lisp function"; }

    bool ExecuteNotify();

protected:
    bool unregister_all_lisp_functions();
    std::map<dsString,LispFunctionBase*> *lisp;
};

#endif // COMMANDUNREGISTER_H
