#ifndef DS_ADDIN_CONNECTION_H
#define DS_ADDIN_CONNECTION_H

/*
Sample Name: LispSample

Sample Description:
    This sample demonstrate the usage of LISP functions, that is how to
    create LISP functions using DSAPI.

Usage:
    This example has two commands, which can be invoked using either the
    command line or by using the menu "LispSample".

    _LSREGISTER "Register Lisp function"
        Registers one or all of this sample's Lisp functions
    
    _LSUNREGISTER "Unregister Lisp function"
        Unregisters one or all of this sample's Lisp functions

    ----------------------------
    Four lisp functions are available in this sample.

    calculate
        Calculates a list of numbers using one of
        the supported operators: +, -, *.
        Example: (calculate "+" 1 2 3 4) returns 10

    concatenatestrings
        Concatenates passed strings and inserts them into a note.
        Example: (concatenatestrings "Hello" "world")

    insertline
        Inserts a line from two given points.
        Example: (insertline 0.0 0.0 0.0 10.0 10.0 0.0)

    paintred
        Paints selected entities red and changes their line weight to 18.
        Example: (paintred (entlast))


Overview:
    Put in a few words, this add-in consists of the following parts:

    Functionality:
        The actual job is done by the two commands and four lisp functions
        involved. This add-in has no graphical interface.

    Command classes:
        All available commands derive from CommandBase. This base class
        provides an interface for both, registering a command to be used
        from the command line via CommandBase::registerCommand() as well as
        putting a command into a menu item via CommandBase::
        createUserCommand(), so done in BlockCustomDataApplication::
        CreateUserInterfaceAndCommands().

    Lisp functions:
        All lisp functions derive from LispFunctionBase. This base class
        provides an interface for creating and registering to, and
        unregistering and removing a lisp function from a document.

    Globally available options:
        This singleton Options class holds a globally accessible pointer
        to the dsApplication_c instance and to this add-in's ID.
        Furthermore, there is the miscellaneous.h, a collection of useful
        functions for converting between dsAPI and Qt classes. These
        functions are used throughout the add-in.

Notable dsAPI functions used:
    dsDocument_c::CreateLispFunction()
    dsDocument_c::RemoveLispFunction()
*/

#include <map>
#include "dsApplication_c.h"
#include "dsInterfacePtr.h"

#include "LispSample_global.h"

// You can append new commands like this:
// 1 - Append the header file here.
// 2 - Add the command as a private member of LispSampleApplication.
// 3 - Go to bool LispSampleApplication::CreateUserInterfaceAndCommands() and:
//     1 - Register your command using the registerCommand()
//         (then the command can be invoked from the command line).
//     2 - If it makes sense, add it to the user menu
//         (then the command can be invoked from the user menu as well).
#include "commands/CommandRegister.h"
#include "commands/CommandUnregister.h"

// Please append your lisp functions like this:
// 1 - Append the header file here.
// 2 - Add the function as a private member of LispSampleApplication.
// 3 - Insert it into the pointer map in LispSampleApplication's constructor.
#include "functions/FunctionCalculate.h"
#include "functions/FunctionConcatenateStrings.h"
#include "functions/FunctionInsertLine.h"
#include "functions/FunctionPaintRed.h"

class LispSample_EXPORT LispSampleApplication
{
public:
    LispSampleApplication(dsApplication_c *dsApp)
        : application(dsApp)
        , m_CommandRegister(&m_lisp)
        , m_CommandUnregister(&m_lisp)
    {
        // Please append lisp functions here
        m_lisp[m_FunctionCalculate.functionName()] = &m_FunctionCalculate;
        m_lisp[m_FunctionConcatenateStrings.functionName()] = &m_FunctionConcatenateStrings;
        m_lisp[m_FunctionInsertLine.functionName()] = &m_FunctionInsertLine;
        m_lisp[m_FunctionPaintRed.functionName()] = &m_FunctionPaintRed;
    }

    dsApplication_c* getDsApp() { return application; } 
    void CreateUserInterfaceAndCommands();
    static const dsString appID;

private:
    dsApplication_ptr application;

    // Pointer map to all available lisp functions. The key is the
    // name of the function, which can be retrieved with functionName().
    std::map<dsString,LispFunctionBase*> m_lisp;

    // Please append commands here
    CommandRegister m_CommandRegister;
    CommandUnregister m_CommandUnregister;

    // Please append lisp functions here
    FunctionCalculate m_FunctionCalculate;
    FunctionConcatenateStrings m_FunctionConcatenateStrings;
    FunctionInsertLine m_FunctionInsertLine;
    FunctionPaintRed m_FunctionPaintRed;
};

#endif // DS_ADDIN_CONNECTION_H
