#include "dsCommandMessage_c.h"
#include "FunctionConcatenateStrings.h"

bool FunctionConcatenateStrings::ExecuteFunctionNotify()
{
    dsObjectPtrArray arguments;
    dsLispParameter_ptr pReturn;
    dsCommandMessage_ptr commandline;
    application->GetCommandMessage(&commandline);

    m_function->GetArguments( &arguments );
    m_function->CreateReturnValue( &pReturn );

    if( !pReturn )
        return false;

    if( arguments.getSize() == 0 )
    {
        commandline->PrintLine(L"Incorrect number of parameters");
        pReturn->SetToNil();
        m_function->SetReturnValue( pReturn );
        return false;
    }

    unsigned int i, iSize = arguments.getSize();
    dsStringArray  StrArray;
    for( i = 0; i < iSize; i++ )
    {
        dsLispParameter_ptr pParam( static_cast< dsLispParameter_c* >( arguments[ i ] ) );
        dsLispParameterType_e type;
        pParam->get_Type( &type );

        if( type == dsLispParameterType_String )
        {
            dsString str;
            pParam->GetString( &str );
            StrArray.add(str);
            StrArray.add(L"\\P");
        }
    }

    //Now create the note entities
    dsDocument_ptr pDoc;
    application->GetActiveDocument(&pDoc);
    dsModel_c* model = 0;
    pDoc->GetModel(&model);
    dsSketchManager_c *dsSketchMgr;
    model->GetSketchManager(&dsSketchMgr);
    dsNote_ptr dsNote;
    dsSketchMgr->InsertNote( 0, 0, 0, 0, 0, 0, StrArray,&dsNote);

    //Zoom extents
    dsDoubleArray LowerLeftArray;
    LowerLeftArray.add(0);
    dsDoubleArray UpperRightArray;
    UpperRightArray.add(0);
    application->Zoom(dsZoomRange_Fit, LowerLeftArray, UpperRightArray);

    //Create a Void return value
    dsLispParameter_ptr pNil;
    m_function->CreateReturnValue( &pNil );
    pNil->SetToVoid();
    m_function->SetReturnValue( pNil );

    return true; 
}
