#ifndef FUNCTIONCONCATENATESTRINGS_H
#define FUNCTIONCONCATENATESTRINGS_H

#include "../LispFunctionBase.h"
#include "../miscellaneous.h"
#include "../Options.h"

class FunctionConcatenateStrings : public LispFunctionBase
{
public:
    FunctionConcatenateStrings() : LispFunctionBase(Options::instance().application) {}
    const dsString groupName() const { return Options::instance().ApiUuid; }
    const dsString functionName() const { return L"concatenatestrings"; }
    const dsString description() const { return
        L"<p>Concatenates passed strings and inserts them into a note.</p>"
        L"<p>Usage example: (concatenatestrings \"Hello\" \"world\")</p>";
    }
    bool ExecuteFunctionNotify();
};

#endif // FUNCTIONCONCATENATESTRINGS_H
