#ifndef DS_ADDIN_CONNECTION_H
#define DS_ADDIN_CONNECTION_H

/*
Sample Name: PostEvent

Sample Description:
    This sample demonstrates the usage of Qt events together with dsAPI events.

Usage:
    Simply load this application and create an entity, for example a circle.
    Then a message box pops up telling the user, that the event was triggered.

Functionality:
    Upon creating the circle, DsAddinDocument::ModifyNotify() will be triggered.
    There, QCoreApplication::postEvent() triggers a PostOperation event.

Globally available options:
    This singleton Options class holds a globally accessible pointer
    to the dsApplication_c instance and to this add-in's ID.
*/

#include <list>
#include "dsApplication_c.h"
#include "dsInterfacePtr.h"
#include "PostEvent_global.h"
#include "dsAddinDocument.h"

class PostEvent_EXPORT PostEventApplication
{
public:
    dsApplication_c* getDsApp() { return application; } 
    static const dsString appID;

    PostEventApplication(dsApplication_c *dsApp) : application(dsApp)
    {
        RegisterApplicationFileNewNotifyHook(application);
        RegisterApplicationFileOpenPostNotifyHook(application);
        RegisterApplicationActiveDocumentChangedNotifyHook(application);
    }

    ~PostEventApplication()
    { 
        UnRegisterApplicationFileNewNotifyHook(application); 
        UnRegisterApplicationFileOpenPostNotifyHook(application);
        UnRegisterApplicationActiveDocumentChangedNotifyHook(application);

        std::list<DsAddinDocument*>::iterator i;
        for (i = m_documents.begin(); i != m_documents.end(); ++i)
            delete *i;
    }

    void ReferenceOpenDocs();

private:
    dsApplication_ptr application;
    std::list<DsAddinDocument*> m_documents;

    DeclareApplicationFileNewNotifyHook
    DeclareApplicationFileOpenPostNotifyHook
    DeclareApplicationActiveDocumentChangedNotifyHook

    bool FileNewNotify(dsDocument_c * docIn);
    bool FileOpenPostNotify(dsDocument_c* docIn);
    bool ActiveDocumentChangedNotify(); 
};

#endif // DS_ADDIN_CONNECTION_H
