#include "stdafx.h"
#include <QCoreApplication>
#include <QEvent>
#include "PostOperation.h"
#include "dsAddinDocument.h"

bool destroyClosedDocument(DsAddinDocument* dsDoc)
{
    if (!dsDoc->isAlive())
    {
        delete dsDoc;
        dsDoc = 0;
        return true;
    }
    return false;
}

bool DsAddinDocument::DestroyNotify()
{
    m_isAlive = false;
    return true;
}

bool DsAddinDocument::ModifyNotify()
{
    QCoreApplication::postEvent(
        new PostOperation(),
        new QEvent((QEvent::Type)(QEvent::User + 1)));
    return true;
}

ImplementDocumentDestroyNotifyHook(DsAddinDocument)
ImplementDocumentModifyNotifyHook(DsAddinDocument)
