#ifndef DS_ADDIN_DOCUMENT_H
#define DS_ADDIN_DOCUMENT_H

#include "PostEvent_global.h"
#include "dsCommand_c.h"
#include "dsInterfacePtr.h"

class PostEvent_EXPORT DsAddinDocument
{
public:
    DsAddinDocument(dsDocument_c *dsDoc)
        : m_document(dsDoc)
    {
        m_isAlive = true; 
        RegisterDocumentDestroyNotifyHook(m_document);
        RegisterDocumentModifyNotifyHook(m_document);
    }

    ~DsAddinDocument()
    { 
        UnRegisterDocumentDestroyNotifyHook(m_document);
        UnRegisterDocumentModifyNotifyHook(m_document);
    }

    DeclareDocumentDestroyNotifyHook
    DeclareDocumentModifyNotifyHook

    bool DestroyNotify();
    bool ModifyNotify(); 
    bool isAlive() const { return m_isAlive; }

private:
    bool m_isAlive;
    dsDocument_ptr m_document;
};

bool destroyClosedDocument(DsAddinDocument* dsDoc);

#endif // DS_ADDIN_DOCUMENT_H
