#ifndef TEXTINSERTIONWIDGET_H
#define TEXTINSERTIONWIDGET_H

#include <list>

#include <QtWidgets/QWidget>
#include <QtCore/QString>
#include <QtWidgets/QTextEdit>

#include "dsApplication_c.h"

#include "ui_TextInsertionWidget.h"

class TextInsertionWidget : public QWidget
{
    Q_OBJECT

public:
    TextInsertionWidget(QWidget *parent = 0);
    Ui::TextInsertionWidgetUI ui;

    QString text() const { return ui.ed_text->toPlainText(); }
    double x1() const { return m_x1; }
    double y1() const { return m_y1; }
    double z1() const { return m_z1; }
    double x2() const { return m_x2; }
    double y2() const { return m_y2; }
    double z2() const { return m_z2; }

    dsColor_c* color() { return ui.cb_color->getColor(); }
    dsString linestyle() const { return ui.cb_linestyle->getLinestyle(); }
    dsLineWeight_e lineweight() const { return ui.cb_lineweight->getLineweight(); }
    dsString textstyle() const { return ui.cb_textstyle->getTextstyle(); }

// The slots are automatically connected due to names convention.
// See also QMetaObject::connectSlotsByName(TextInsertionWidget);
protected slots:
    void on_ed_p1_textChanged(const QString &text);
    void on_ed_p2_textChanged(const QString &text);

protected:
    dsApplication_c *application;

    double m_x1, m_y1, m_z1;
    double m_x2, m_y2, m_z2;
};

#endif // TEXTINSERTIONWIDGET_H
