#include "dsInterfacePtr.h"
#include "dsDocument_c.h"
#include "dsLineStyleManager_c.h"
#include "dsLineStyle_c.h"
#include "dsEntityHelper_c.h"

#include "Options.h"
#include "dsLinestyleCombobox.h"

void dsLinestyleCombobox::populate()
{
    disconnect(this, SIGNAL(activated(int)), this, SLOT(on_activated(int)));
    clear();

    dsDocument_ptr doc;
    Options::instance().application->GetActiveDocument(&doc);
    if (!doc)
        return;

    dsLineStyleManager_ptr manager;
    doc->GetLineStyleManager(&manager);
    dsEntityHelper_ptr helper;
    Options::instance().application->GetEntityHelper(&helper);

    unsigned int active_style_index = 0;
    dsLineStyle_ptr active_style;
    manager->GetActiveLineStyle(&active_style);
    dsObjectPtrArray styles;
    manager->GetLineStyles(&styles);

    for (unsigned int i = 0; i < styles.getSize(); ++i)
    {
        dsLineStyle_c *style = (dsLineStyle_c*)styles[i];

        dsString name;
        style->get_Name(&name);
        addItem(d2q(name));

        bool same = false;
        helper->CompareObjects(active_style, style, &same);
        if (same)
            active_style_index = i;
    }

    if (styles.getSize() > 0)
    {
        setCurrentIndex(active_style_index);
        m_linestyle = q2d(currentText());
    }

    addItem(tr("Specify Line style..."));
    connect(this, SIGNAL(activated(int)), SLOT(on_activated(int)));
}

void dsLinestyleCombobox::on_activated( int index )
{
    if (index < count() - 1)
    {
        m_linestyle = q2d(currentText());
    }
    else
    {
        dsRunCommandError_e error;
        Options::instance().application->RunCommand(
            L"_LINESTYLE",
            true,
            &error);
        populate();
    }
}
