#ifndef DS_ADDIN_CONNECTION_H
#define DS_ADDIN_CONNECTION_H

/*
Sample Name: DictionaryXDataDemo

Sample Description:
    This sample demonstrates the usage of dictionaries and xdata.

Usage:
    _XDATADEMO
        The sole command of this add-in does this:
        > Creates a circle
        > Get named object dictionary (global dictionary)
        > Attach some data to the dictionary
        > Create XRecord and attach both dictionary and xdata to the circle
        > Finally release the xdata and dictionary, after showing their
          content
Overview:
    Functionality:
        We want to draw our attention to the method
        CommandDemo::ExecuteNotify(), where the usage of
        dictionaries and xdata is shown.

    Command classes:
        _XDATADEMO (class CommandDemo) derives from CommandBase. This base
        class provides an interface for both, registering a command to be
        used from the command line via CommandBase::registerCommand() as
        well as putting a command into a menu item via CommandBase::
        createUserCommand(), so done in ContextMenuApplication::
        CreateUserInterfaceAndCommands().

    Globally available options:
        This singleton Options class holds a globally accessible pointer
        to the application as well as the UUID of this add-in. You can add
        any data that is ought to be available throughout this program.

        Furthermore, there is the miscellaneous.h, a collection of useful
        functions for converting between dsAPI and Qt classes. These
        functions are used throughout the add-in.

Notable dsAPI functions used:
        dsDocument_c::GetNamedObjectsDictionary()
        dsDictionary_c::CreateDictionary()
        dsDictionary_c::CreateXRecord()
        ds~_c::CreateExtensionDictionary()
        ds~_c::ReleaseExtensionDictionary()
*/

#include "dsApplication_c.h"
#include "dsInterfacePtr.h"
#include "DictionaryXDataDemo_global.h"

// You can append new commands like this:
// 1 - Append the header file here.
// 2 - Add the command as a private member of DictionaryXDataDemoApplication.
// 3 - Go to bool DictionaryXDataDemoApplication::CreateUserInterfaceAndCommands()
//     and:
//     1 - Register your command using the registerCommand()
//         (then the command can be invoked from the command line).
//     2 - If it makes sense, add it to the user menu
//         (then the command can be invoked from the user menu as well).
#include "commands/CommandDemo.h"

class DictionaryXDataDemo_EXPORT DictionaryXDataDemoApplication
{
public:
    DictionaryXDataDemoApplication(dsApplication_c *dsApp) : application(dsApp) {}
    void CreateUserInterfaceAndCommands();
    static const dsString appID;

private:
    dsApplication_ptr application;
    CommandDemo m_CommandDemo;
};

#endif // DS_ADDIN_CONNECTION_H
