#include "dsInterfacePtr.h"
#include "dsDocument_c.h"
#include "dsModel_c.h"
#include "dsSketchManager_c.h"
#include "dsCircle_c.h"

#include "CircleInserter.h"

CircleInserter::CircleInserter(dsApplication_c *application, QWidget *parent)
    : QWidget(parent)
    , application(application)
{
    ui.setupUi(this);
}

void CircleInserter::on_bt_draw_clicked()
{
    double x = ui.ed_x->text().toDouble();
    double y = ui.ed_y->text().toDouble();
    double z = ui.ed_z->text().toDouble();
    double r = ui.ed_r->text().toDouble();

    dsDocument_ptr doc;
    application->GetActiveDocument(&doc);
    dsModel_ptr model;
    doc->GetModel(&model);
    dsSketchManager_ptr sketchmanager;
    model->GetSketchManager(&sketchmanager);
    dsCircle_ptr circle;
    sketchmanager->InsertCircle(x, y, z, r, &circle);
}

bool CircleInserter::event( QEvent * event )
{
    event->accept();
    return true;
}