#include "stdafx.h"
#include <QWidget>
#include <QVBoxLayout>
#include "CircleInserter.h"
#include "dsAddinConnection.h"

DockWidgetApplication *globalDockWidgetApplication = 0;

bool DockWidgetApplication::createDockWidget()
{
    DSRESULT r = m_dsApp->CreateCustomPropertyControl2(
        L"Hello Circle C++ Qt",
        dsCustomPropertyControlArea_Right,
        dsCustomPropertyControlArea_Left | dsCustomPropertyControlArea_Right,
        &m_dock);

    if (r != DSRESULT_True || !m_dock)
        return false;

    // Although HWND is Windows-specific vocabulary,
    // this should work platform-independently.
    long handle = 0;
    m_dock->GetHWND(&handle);
    QWidget *widget = QWidget::find((WId)handle);

    // Can that happen?
    if (!widget)
        return false;

    // Fill the dock widget with life.
    CircleInserter *inserter = new CircleInserter(m_dsApp, widget);
    QVBoxLayout *vbox = new QVBoxLayout;
    vbox->addWidget(inserter);
    widget->setLayout(vbox);
    widget->show();
    m_dock->put_Visible(true);

    // Return if the circle inserter was created.
    return inserter;
}

#ifdef DS_WIN
DockWidget_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#else //DS_WIN
extern "C" DockWidget_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#endif //DS_WIN
{
    if (!globalDockWidgetApplication)
    {
        globalDockWidgetApplication = new DockWidgetApplication(dsApp);
        return globalDockWidgetApplication->createDockWidget();
    }
    return false;
}

#ifdef DS_WIN
DockWidget_EXPORT bool disconnectFromDraftSight()
#else //DS_WIN
extern "C" DockWidget_EXPORT bool disconnectFromDraftSight()
#endif //DS_WIN
{
    if (globalDockWidgetApplication)
    {
        delete globalDockWidgetApplication;
        globalDockWidgetApplication = 0;
    }
    return true;
}

#ifdef DS_WIN
DockWidget_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#else //DS_WIN
extern "C" DockWidget_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#endif //DS_WIN
{
    *sId1 = L"50FF1606-A4E7-4020-B641-5E5F63619B66";
    return true;
}
