#ifndef DS_ADDIN_CONNECTION_H
#define DS_ADDIN_CONNECTION_H

/*
Sample Name: DockWidget

Sample Description:
    This sample demonstrates how to use a Qt widget within the dsAPI. It
    creates a simple docking widget in DraftSight. Using this widget we
    can create a circle specifying radius and position.

Notable dsAPI functions used:
    dsApplication_c::CreateCustomPropertyControl2()
    dsSketchManager_c::InsertCircle()
*/

#include "dsApplication_c.h"
#include "dsInterfacePtr.h"
#include "DockWidget_global.h"
#include "dsCustomPropertyControl_c.h"

class DockWidget_EXPORT DockWidgetApplication  
{
public:
    DockWidgetApplication(dsApplication_c *dsApp)
        : m_dsApp(dsApp)
        , m_dock(0)
    {}

    ~DockWidgetApplication()
    {
        if (m_dock)
            m_dock->Destroy();
    }

    bool createDockWidget();

private:
    dsApplication_ptr m_dsApp;
    dsInterfacePtr<dsCustomPropertyControl_c> m_dock;
};

#endif // DS_ADDIN_CONNECTION_H
