#include "dsCommandMessage_c.h"
#include "dsDocument_c.h"
#include "dsModel_c.h"
#include "dsSketchManager_c.h"
#include "dsInterfacePtr.h"
#include "CommandDrawTable.h"

bool CommandDrawTable::ExecuteNotify()
{
    // Get command line interface
    dsCommandMessage_c* pCommandline;
    application->GetCommandMessage( &pCommandline);

    dsDocument_ptr pDocument;
    application->GetActiveDocument( &pDocument );

    // Let the user enter the table's top left position
    DSRESULT dsReturn;
    bool bResult;
    double dCenterX = 0;
    double dCenterY = 0; 
    double dCenterZ = 0;

    dsReturn = pCommandline->PromptForPoint( L"Specify top left point for table", &dCenterX, &dCenterY, &dCenterZ, &bResult);

    if ( dsReturn != DSRESULT_True || !bResult)
    {
        return false;
    }

    dsTableStyle_c *pTablestyle;
    dsTableStyleManager_ptr pTablestylemgr;
    pDocument->GetTableStyleManager( &pTablestylemgr);
    dsCreateObjectResult_e result1;
    dsString tableStyleName = L"newtablestyle";
    pTablestylemgr->CreateTableStyle(tableStyleName, &pTablestyle, &result1);

    dsColor_ptr color;
    pTablestyle->GetBordersColor( dsTableCellType_Header, dsTableBordersLineType_HorizontalInside, &color );
    color->SetNamedColor(dsNamedColor_Yellow);

    for (int celltype = 1 ; celltype<=3; celltype++)//in Enum.GetValues(typeof(dsTableCellType_e)))
    {
        for (int borderLineType = 1 ; borderLineType<=32; borderLineType = borderLineType *2)
        {
            pTablestyle->SetBordersColor((dsTableCellType_e)celltype,(dsTableBordersLineType_e)borderLineType,color);				
        }
    }

    for (int celltype = 1 ; celltype<=3; celltype++)//in Enum.GetValues(typeof(dsTableCellType_e)))
    {
        for (int borderLineType = 1 ; borderLineType<=32; borderLineType = borderLineType *2)//in Enum.GetValues(typeof(dsTableBordersLineType_e)))
        {
            pTablestyle->SetBordersVisibility((dsTableCellType_e)celltype, (dsTableBordersLineType_e)borderLineType, true);
        }
    }

    for (int celltype = 1 ; celltype<=3; celltype++)//in Enum.GetValues(typeof(dsTableCellType_e)))
    {
        pTablestyle->SetTextColor( (dsTableCellType_e)celltype, color );
    }

    //Activate the Table style created above
    pTablestyle->Activate();

    //Add Table entity to drawing
    dsModel_ptr pModel;
    pDocument->GetModel(&pModel);
    dsSketchManager_ptr pSketchmanager;
    pModel->GetSketchManager( &pSketchmanager );

    long lRows = 3;
    long lColumns = 4;
    double dRowHeight = 0.5;
    double dColoumWidth = 2.0;

    dsTable_ptr pTable;
    pSketchmanager->InsertTable( dCenterX, dCenterY, lRows, lColumns, dRowHeight, dColoumWidth, dsTableCellType_Title, dsTableCellType_Header, dsTableCellType_Data, &pTable );

    pTable->SetText( 0, 0, L"Bill of Materials" );
    pTable->SetText( 1, 0, L"Item " );
    pTable->SetText( 1, 1, L"Description" );
    pTable->SetText( 1, 2, L"Part No" );
    pTable->SetText( 1, 3, L"Qty" );
    pTable->SetText( 2, 0, L"1");
    pTable->SetText( 2, 1, L"My Description" );
    pTable->SetText( 2, 2, L"1.0" );
    pTable->SetText( 2, 3, L"1" );

    pTable->SetCellAlignment( 0, 0, dsTableCellAlignment_MiddleCenter );
    pTable->SetCellAlignment( 1, 0, dsTableCellAlignment_MiddleCenter );
    pTable->SetCellAlignment( 1, 1, dsTableCellAlignment_MiddleLeft );
    pTable->SetCellAlignment( 1, 2, dsTableCellAlignment_MiddleLeft );
    pTable->SetCellAlignment( 1, 3, dsTableCellAlignment_MiddleCenter );
    pTable->SetCellAlignment( 2, 0, dsTableCellAlignment_MiddleCenter );
    pTable->SetCellAlignment( 2, 1, dsTableCellAlignment_MiddleLeft );
    pTable->SetCellAlignment( 2, 2, dsTableCellAlignment_MiddleLeft );
    pTable->SetCellAlignment( 2, 3, dsTableCellAlignment_MiddleCenter );

    return true;
}
