#include <QString>
#include <QDir>
#include <QFileInfo>

#include "dsInterfacePtr.h"
#include "dsDocument_c.h"
#include "dsDocumentExporter_c.h"
#include "dsCommandMessage_c.h"

#include "miscellaneous.h"
#include "Converter.h"

void Converter::convert(const QStringList &drawings)
{
    int i = 1;
    QString accumulated_messages;
    foreach (QString drawing, drawings)
    {
        QString message;
        QFileInfo drawing_info(drawing);
        QString png = QString::fromLatin1("%1/%2.png")
            .arg(drawing_info.absolutePath())
            .arg(drawing_info.baseName());
        dsDocument_ptr doc;
        application->OpenDocument(q2d(drawing), dsDocumentOpen_Default, &doc);
        bool exported = false;
        if (doc)
        {
            dsDocumentExporter_ptr exporter;
            doc->GetDocumentExporter(&exporter);
            exporter->ExportToPng(q2d(png), &exported);
        }
        else
        {
            message = tr(
                "<p style=\"color:#990000;font-weight:bold\">"
                "[%1/%2]: Error: Could not load \"%3\".</p>")
                .arg(i++).arg(drawings.size()).arg(drawing);
        }

        if (exported)
        {
            message = tr(
                "<p style=\"color:#0033cc;font-weight:bold\">"
                "[%1/%2]: Converted \"%3\" to \"%4\".</p>")
                .arg(i++).arg(drawings.size()).arg(drawing).arg(png);
        }
        else
        {
            message = tr(
                "<p style=\"color:#990000;font-weight:bold\">"
                "[%1/%2]: Error: Could not convert \"%3\" to \"%4\".</p>")
                .arg(i++).arg(drawings.size()).arg(drawing).arg(png);
        }

        accumulated_messages += message;
        dsCommandMessage_ptr command_line;
        application->GetCommandMessage(&command_line);
        command_line->PrintLine(q2d(message));

        // Close the document, and thus also its command window
        if (doc)
            application->CloseDocument(q2d(QDir::toNativeSeparators(drawing)), false);
    } // over all dwg_files

    // Write all output to the original document's command window, i.e.
    // the document that was active before the conversion commenced.
    dsCommandMessage_ptr command_line;
    application->GetCommandMessage(&command_line);
    command_line->PrintLine(q2d(accumulated_messages));
}
