#ifndef ENTITYPREVIEWDIALOG_H
#define ENTITYPREVIEWDIALOG_H

#include <QDialog>
#include <QImage>
#include <QGraphicsScene>
#include "ui_EntityPreviewDialog.h"

class EntityPreviewDialog : public QDialog
{
    Q_OBJECT

public:
    EntityPreviewDialog(
        QImage *imageAllGeometry,
        QImage *imageCurrentView,
        QImage *imageNamedView,
        QImage *imageSpecifyWindow,
        QWidget *parent = 0);

public slots:
    void on_bt_all_geometry_clicked();
    void on_bt_current_view_clicked();
    void on_bt_named_view_clicked();
    void on_bt_specify_window_clicked();

private:
    Ui::EntityPreviewDialog ui;

    QImage *imageAllGeometry;
    QImage *imageCurrentView;
    QImage *imageNamedView;
    QImage *imageSpecifyWindow;
    QGraphicsScene m_scene;
};

#endif // ENTITYPREVIEWDIALOG_H
