#ifndef MISCELLANEOUS_H
#define MISCELLANEOUS_H

#include <QString>
#include "dsString.h"
#include "dsConstants.h"

// Lacking initializer lists, we have this hack here. Please use it with
// extreme caution! It converts a list of T to a corresponding dsTArray.
// Example: makeArray<dsDoubleArray, double>(3, 0.0, 1.0, 2.0) returns
//          a dsDoubleArray containing three values: 0, 1 and 2.
// Note   : Decommission this function, once C++11 is available.
template <typename dsTArray, typename T>
dsTArray makeArray(size_t length, ...)
{
    dsTArray result;
    va_list arguments;
    va_start(arguments, length);
    for (size_t i = 0; i < length; ++i)
        result.add(va_arg(arguments, T));
    va_end(arguments);
    return result;
}

// Converts a QString into a dsString.
dsString q2d(const QString &s);

// Converts a dsString into a QString.
QString d2q(const dsString &s);

#endif // MISCELLANEOUS_H
