#include "stdafx.h"
#include "Options.h"
#include "dsAddinConnection.h"

MyPrintApplication *globalMyPrint = 0;
const dsString MyPrintApplication::appID = L"6B51BAF7-4726-40d1-836B-0AF8C1DBBFC1";

void MyPrintApplication::CreateUserInterfaceAndCommands()
{
    m_CommandMyPrint.createAndRegisterCommand();
	
	// Menu should be between "Modify" and "Tools" menus
    const int USERMENU_POSITION = 9;

    // Create user menu
    dsMenuItem_ptr menu;
    application->AddMenu(
        MyPrintApplication::appID,
        dsUIState_Document,
        USERMENU_POSITION,
        L"MyPrintSample",
        &menu);
    if (!menu)
        return;
    long menu_position = 1;

    // Create toolbar
    dsToolbar_ptr toolbar;
    application->AddToolbar(
        MyPrintApplication::appID,
        dsUIState_Document,
        L"MyPrintSample",
        &toolbar);
    if (!toolbar)
        return;
    long toolbar_position = 1;

    // 2 - Then append your command here, where you see fit in the menus.
    //     You can also create a new menu.

    m_CommandMyPrint.createUserCommand();
    m_CommandMyPrint.insert(menu, menu_position++);
    m_CommandMyPrint.insert(toolbar, toolbar_position++);
}

#ifdef DS_WIN
MyPrint_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#else //DS_WIN
extern "C" MyPrint_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#endif //DS_WIN
{
    if (!globalMyPrint)
    {
        // The options have to be set before the application
        // is created, because the commands rely on them.
        Options::instance().application = dsApp;
        Options::instance().ApiUuid = MyPrintApplication::appID;
        globalMyPrint = new MyPrintApplication(dsApp);
        globalMyPrint->CreateUserInterfaceAndCommands();
    }
    return globalMyPrint;
}

#ifdef DS_WIN
MyPrint_EXPORT bool disconnectFromDraftSight()
#else //DS_WIN
extern "C" MyPrint_EXPORT bool disconnectFromDraftSight()
#endif //DS_WIN
{
    if (globalMyPrint)
    {
        Options::instance().application->RemoveUserInterface(
            MyPrintApplication::appID);
        delete globalMyPrint;
        globalMyPrint = 0;
    }
    return true;
}

#ifdef DS_WIN
MyPrint_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#else //DS_WIN
extern "C" MyPrint_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#endif //DS_WIN
{
    *sId1 = dsString( L"D154DD0B-47F9-47d5-BF32-C491AF796702" );
    return true;
}
