#ifndef DS_ADDIN_CONNECTION_H
#define DS_ADDIN_CONNECTION_H

/*
Sample Name: Reactors

Sample Description:
    This sample shows how to use reactors in the dsAPI add-ins.

Usage:
    This sample has no command, it simple reacts, as its names suggests, to
    the following events:
        * when creating a new document
        * before opening an existing document
        * after an existing document was opened
        * when the active document has changed
        * before DraftSight closes
        * when closing a document
        * before saving a document
        * after a document was saved
        * when a document has changed
        * on selecting or un-selecting entities

Notable hooks used:
        ApplicationFileNewNotifyHook
        ApplicationFileOpenPreNotifyHook
        ApplicationFileOpenPostNotifyHook
        ApplicationActiveDocumentChangedNotifyHook
        ApplicationDestroyNotifyHook
        DocumentDestroyNotifyHook
        DocumentFileSavePreNotifyHook
        DocumentFileSavePostNotifyHook
        DocumentModifyNotifyHook
        SelectionManagerSelectionChangedNotifyHook
*/

#include <list>
#include <QCoreApplication>
#include "dsApplication_c.h"
#include "dsInterfacePtr.h"
#include "dsAddinDocument.h"
#include "Reactors_global.h"

class Reactors_EXPORT ReactorsApplication
{
    Q_DECLARE_TR_FUNCTIONS(ReactorsApplication)
public:
    static const dsString appID;

    ReactorsApplication(dsApplication_c *dsApp) : application(dsApp)
    {
        RegisterApplicationFileNewNotifyHook(application);
        RegisterApplicationFileOpenPreNotifyHook(application);
        RegisterApplicationFileOpenPostNotifyHook(application);
        RegisterApplicationActiveDocumentChangedNotifyHook(application);
        RegisterApplicationDestroyNotifyHook(application);
    }
    
    ~ReactorsApplication()
    {
        UnRegisterApplicationFileNewNotifyHook(application);
        UnRegisterApplicationFileOpenPreNotifyHook(application);
        UnRegisterApplicationFileOpenPostNotifyHook(application);
        UnRegisterApplicationActiveDocumentChangedNotifyHook(application);
        UnRegisterApplicationDestroyNotifyHook(application);

        std::list<DsAddinDocument*>::iterator i;
        for (i = m_documents.begin(); i != m_documents.end(); ++i)
            delete *i;
    }

    void ReferenceOpenDocs();

private:
    dsApplication_ptr application;
    std::list<DsAddinDocument*> m_documents;

    DeclareApplicationFileNewNotifyHook
    DeclareApplicationFileOpenPreNotifyHook
    DeclareApplicationFileOpenPostNotifyHook
    DeclareApplicationActiveDocumentChangedNotifyHook
    DeclareApplicationDestroyNotifyHook

    bool FileNewNotify(dsDocument_c *docIn);
    bool FileOpenPreNotify(dsString fileName, dsDocumentOpenOption_e Option); 
    bool FileOpenPostNotify(dsDocument_c *docIn);
    bool ActiveDocumentChangedNotify(); 
    bool DestroyNotify();
};

#endif // DS_ADDIN_CONNECTION_H
