#ifndef DS_ADDIN_DOCUMENT_H
#define DS_ADDIN_DOCUMENT_H

#include <QCoreApplication>
#include "Reactors_global.h"
#include "dsDocument_c.h"
#include "dsSelectionManager_c.h"
#include "dsInterfacePtr.h"

class Reactors_EXPORT DsAddinDocument
{
    Q_DECLARE_TR_FUNCTIONS(DsAddinDocument)
public:

    DsAddinDocument(dsDocument_c *dsDoc) : document(dsDoc)
    {
        RegisterDocumentDestroyNotifyHook(document);
        RegisterDocumentFileSavePreNotifyHook(document);
        RegisterDocumentFileSavePostNotifyHook(document);
        RegisterDocumentModifyNotifyHook(document);

        document->GetSelectionManager(&m_selection_manager);
        RegisterSelectionManagerSelectionChangedNotifyHook(m_selection_manager);
    }

    ~DsAddinDocument() 
    { 
        UnRegisterDocumentDestroyNotifyHook(document);
        UnRegisterDocumentFileSavePreNotifyHook(document);
        UnRegisterDocumentFileSavePostNotifyHook(document);
        UnRegisterDocumentModifyNotifyHook(document);
        UnRegisterSelectionManagerSelectionChangedNotifyHook(m_selection_manager);
    }

    DeclareDocumentDestroyNotifyHook
    DeclareDocumentFileSavePreNotifyHook
    DeclareDocumentFileSavePostNotifyHook
    DeclareDocumentModifyNotifyHook
    DeclareSelectionManagerSelectionChangedNotifyHook

    bool DestroyNotify();
    bool FileSavePreNotify(dsString FileName, dsDocumentSaveAsOption_e SaveOption);
    bool FileSavePostNotify(); 
    bool ModifyNotify(); 
    bool SelectionChangedNotify(); 

    bool isAlive() const { return m_isAlive; }
private:
    dsDocument_ptr document;
    dsSelectionManager_ptr m_selection_manager;
    bool m_isAlive;
};

bool destroyClosedDocument(DsAddinDocument *dsDoc);

#endif // DS_ADDIN_DOCUMENT_H
