#include "dsCommandMessage_c.h"
#include "CommandShowTypes.h"
#include <sstream>

bool CommandShowTypes::ExecuteNotify()
{
    dsCommandMessage_ptr commandline;
    application->GetCommandMessage(&commandline);

    bool result;
    if (commandline->PromptForSelection(
        false,
        L"Select entities",
        L"",
        &result) != DSRESULT_True || !result)
    {
        return false;
    }

    dsDocument_ptr document;
    application->GetActiveDocument(&document);
    dsSelectionManager_ptr selectionmanager;
    document->GetSelectionManager(&selectionmanager);
    long selected_objects_count = 0;
    selectionmanager->GetSelectedObjectCount(
        dsSelectionSetType_Current, &selected_objects_count);
	std::wostringstream promptForCurrent;
	promptForCurrent << selected_objects_count
					 << L" entities selected (dsSelectionSetType_Current)";
    commandline->PrintLine( promptForCurrent.str().c_str() );
    selectionmanager->GetSelectedObjectCount(
        dsSelectionSetType_Previous, &selected_objects_count);
	std::wostringstream promptForPrev;
	promptForPrev << selected_objects_count
				  << L" entities selected (dsSelectionSetType_Previous)";
    commandline->PrintLine( promptForPrev.str().c_str() );

    for (long i = 0; i < selected_objects_count; ++i)
    {
        dsObjectType_e type;
        dsObject *o;
        selectionmanager->GetSelectedObject(
            dsSelectionSetType_Previous, i, &type, &o);

		std::wostringstream prompt;
		prompt << i
			   << L": "
			   << d2s(type)
			   << L"("
			   << type
			   << L")";
		commandline->PrintLine( prompt.str().c_str() );
    }

    return true; 
}
