#include "stdafx.h"
#include "Options.h"
#include "dsAddinConnection.h"

SelectionApplication *globalSelectionApplication = 0;
const dsString SelectionApplication::appID = L"1C85DA6C-0445-4844-A66F-A048A5787A68";

void SelectionApplication::CreateUserInterfaceAndCommands()
{
    // 1 - First register your command here
    //     (for invoking the command from the command line)
    m_CommandShowTypes.createAndRegisterCommand();
    m_CommandConnectTwoLines.createAndRegisterCommand();

    // Menu should be between "Modify" and "Tools" menus
    const int USERMENU_POSITION = 9;

    // Create user menu
    dsMenuItem_ptr menu;
    application->AddMenu(
        SelectionApplication::appID,
        dsUIState_Document,
        USERMENU_POSITION,
        L"SelectionSample",
        &menu);
    if (!menu)
        return;
    long menu_position = 1;

    // Create toolbar
    dsToolbar_ptr toolbar;
    application->AddToolbar(
        SelectionApplication::appID,
        dsUIState_Document,
        L"SelectionSample",
        &toolbar);
    if (!toolbar)
        return;
    long toolbar_position = 1;

    // 2 - Then append your command here, where you see fit in the menus.
    //     You can also create a new menu.
    m_CommandShowTypes.createUserCommand();
    m_CommandShowTypes.insert(menu, menu_position++);
    m_CommandShowTypes.insert(toolbar, toolbar_position++);
    m_CommandConnectTwoLines.createUserCommand();
    m_CommandConnectTwoLines.insert(menu, menu_position++);
    m_CommandConnectTwoLines.insert(toolbar, toolbar_position++);
}

#ifdef DS_WIN
Selection_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#else //DS_WIN
extern "C" Selection_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#endif //DS_WIN
{
    if (!globalSelectionApplication)
    {
        Options::instance().application = dsApp;
        Options::instance().ApiUuid = SelectionApplication::appID;
        globalSelectionApplication = new SelectionApplication(dsApp);
        globalSelectionApplication->CreateUserInterfaceAndCommands();
    }
    return globalSelectionApplication;
}

#ifdef DS_WIN
Selection_EXPORT bool disconnectFromDraftSight()
#else //DS_WIN
extern "C" Selection_EXPORT bool disconnectFromDraftSight()
#endif //DS_WIN
{
    if (globalSelectionApplication)
    {
        Options::instance().application->RemoveUserInterface(
            SelectionApplication::appID);
        delete globalSelectionApplication;
        globalSelectionApplication = 0;
    }
    return true;
}

#ifdef DS_WIN
Selection_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#else //DS_WIN
extern "C" Selection_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#endif //DS_WIN
{
    *sId1 = dsString( L"A085E761-D046-4f6b-BFA2-02F0DDD1B10E" );
    return true;
}
