#include "CommandModify.h"

bool CommandModify::ExecuteNotify(void)
{
    dsCommandMessage_c* commandline;
    application->GetCommandMessage(&commandline);

    dsStringArray global_keywords;
    global_keywords.add(L"_Mainframe");
    global_keywords.add(L"_Document");

    dsStringArray local_keywords;
    local_keywords.add(L"Mainframe");
    local_keywords.add(L"Document");

    dsString keyword;
    dsPromptResultType_e result;
    commandline->PromptForKeyword2(
        L"Select window",
        L"",
        global_keywords,
        local_keywords,
        0,
        global_keywords[0],
        &keyword,
        &result);
    if (result != dsPromptResultType_Keyword)
        return false;

    dsDSWindow_ptr window;
    if (keyword.CompareNoCase(dsString(L"_Mainframe")) == 0)
    {
        application->GetMainWindow(&window);
    }
    else if (keyword.CompareNoCase(dsString(L"_Document")) == 0)
    {
        dsDocument_ptr document;
        application->GetActiveDocument(&document);
        document->GetWindow(&window);
    }
    if (!window)
        return false;

    global_keywords.clear();
    global_keywords.add(L"_Info");
    global_keywords.add(L"_Frame edit");
    global_keywords.add(L"_Geometry edit");
    global_keywords.add(L"_Visibility edit");
    global_keywords.add(L"_State edit");

    local_keywords.clear();
    local_keywords.add(L"Info");
    local_keywords.add(L"Frame edit");
    local_keywords.add(L"Geometry edit");
    local_keywords.add(L"Visibility edit");
    local_keywords.add(L"State edit");

    keyword = L"";
    commandline->PromptForKeyword2(
        L"Select edit action",
        L"",
        global_keywords,
        local_keywords,
        0,
        global_keywords[0],
        &keyword,
        &result);
    if (result != dsPromptResultType_Keyword)
        return false;

    if (keyword.CompareNoCase(dsString(L"_Info")) == 0)
    {
        printWindowInfo(commandline, window);
    }
    else if (keyword.CompareNoCase(dsString(L"_Frame")) == 0)
    {
        long x = 0, y = 0, w = 0, h = 0;
        bool result;

        window->GetFramePosition(&x, &y);
        commandline->PromptForInteger(L"Position x", x, &x, &result);
        if (!result)
            return false;
        commandline->PromptForInteger(L"Position y", y, &y, &result);
        if (!result)
            return false;

        window->GetFrameSize(&h, &w);
        commandline->PromptForInteger(L"Width", w, &w, &result);
        if (!result)
            return false;
        commandline->PromptForInteger(L"Height", h, &h, &result);
        if (!result)
            return false;

        window->SetFramePosition(x, y);
        window->SetFrameSize(h, w);
    }
    else if (keyword.CompareNoCase(dsString(L"_Geometry")) == 0)
    {
        bool result;
        long x = 0, y = 0, w = 0, h = 0;

        window->GetGeometryPosition(&x, &y);
        commandline->PromptForInteger(L"Position x", x, &x, &result);
        if (!result)
            return false;
        commandline->PromptForInteger(L"Position y", y, &y, &result);
        if (!result)
            return false;

        window->GetGeometrySize(&h, &w);
        commandline->PromptForInteger(L"Width", w, &w, &result);
        if (!result)
            return false;
        commandline->PromptForInteger(L"Height", h, &h, &result);
        if (!result)
            return false;

        window->SetGeometryPosition(x, y);
        window->SetGeometrySize(h, w);
    }
    else if (keyword.CompareNoCase(dsString(L"_Visibility")) == 0)
    {
        bool visible, result;
        window->get_Visible(&visible);
        commandline->PromptForBool(
            L"Visible",
            L"Yes",
            L"No",
            visible,
            &visible,
            &result);
        if (!result)
            return false;

        window->put_Visible(visible);
    }
    else if (keyword.CompareNoCase(dsString(L"_State")) == 0)
    {
        bool result;
        dsWindowState_e state;
        window->get_WindowState(&state);
        long n = state;
        commandline->PromptForInteger(
            L"State (0 - Min, 1 - Max, 2 - Norm)", n, &n, &result);
        if (!result)
            return false;

        window->put_WindowState((dsWindowState_e)n);
    }
    return true; 
}
