#include "stdafx.h"
#include "Options.h"
#include "dsAddinConnection.h"

WindowsApplication *globalWindowsApplication = 0;
const dsString WindowsApplication::appID = L"62A70E9D-238F-4252-B102-CDA09F49A0DE";

void WindowsApplication::CreateUserInterfaceAndCommands()
{
    // 1 - First register your command here
    //     (for invoking the command from the command line)
    m_CommandInfo.createAndRegisterCommand();
    m_CommandModify.createAndRegisterCommand();

    // Menu should be between "Modify" and "Tools" menus
    const int USERMENU_POSITION = 9;

    // Create user menu
    dsMenuItem_ptr menu;
    application->AddMenu(
        WindowsApplication::appID,
        dsUIState_Document,
        USERMENU_POSITION,
        L"Windows sample",
        &menu);
    if (!menu)
        return;
    long menu_position = 1;

    // Create toolbar
    dsToolbar_ptr toolbar;
    application->AddToolbar(
        WindowsApplication::appID,
        dsUIState_Document,
        L"Windows sample",
        &toolbar);
    if (!toolbar)
        return;
    long toolbar_position = 1;

    // 2 - Then append your command here, where you see fit in the menus.
    //     You can also create a new menu.

    m_CommandInfo.createUserCommand();
    m_CommandInfo.insert(menu, menu_position++);
    m_CommandInfo.insert(toolbar, toolbar_position++);
    m_CommandModify.createUserCommand();
    m_CommandModify.insert(menu, menu_position++);
    m_CommandModify.insert(toolbar, toolbar_position++);
}

#ifdef DS_WIN
Windows_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#else //DS_WIN
extern "C" Windows_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#endif //DS_WIN
{
    if (!globalWindowsApplication)
    {
        Options::instance().application = dsApp;
        Options::instance().ApiUuid = WindowsApplication::appID;
        globalWindowsApplication = new WindowsApplication(dsApp);
        globalWindowsApplication->CreateUserInterfaceAndCommands();
    }
    return globalWindowsApplication;
}

#ifdef DS_WIN
Windows_EXPORT bool disconnectFromDraftSight()
#else //DS_WIN
extern "C" Windows_EXPORT bool disconnectFromDraftSight()
#endif //DS_WIN
{
    if (globalWindowsApplication)
    {
        Options::instance().application->RemoveUserInterface(
            WindowsApplication::appID);
        delete globalWindowsApplication;
        globalWindowsApplication = 0;
    }
    return true;
}

#ifdef DS_WIN
Windows_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#else //DS_WIN
extern "C" Windows_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#endif //DS_WIN
{
    *sId1 = dsString( L"95A10A2D-6ED3-41c9-87F5-F7F7E9469F50" );
    return true;
}
