#ifndef DS_ADDIN_CONNECTION_H
#define DS_ADDIN_CONNECTION_H

/*
Sample Name: Windows

Sample Description:
    This sample demonstrates the usage of Window editing functions.

Usage:
    There are two commands.

    _WINFO "Window info"
        This command shows window properties of the main window and the
        active document.

    _WMODIFY "Modify window"
        With this command, the user can move and resize the main window
        or the window of the active document.

Overview:
    Functionality:
        We want to draw your attention to the bodies of the two commands:
            * CommandInfo::ExecuteNotify()
            * CommandModify::ExecuteNotify()
        There you can see how you can retrieve and modify window
        properties.


    Command classes:
        Both commands derive from CommandBase. This base class provides an
        interface for both, registering a command to be used from the
        command line via CommandBase::registerCommand() as well as putting
        a command into a menu item via CommandBase::createUserCommand(), so
        done in WindowsApplication::CreateUserInterfaceAndCommands().

    Globally available options:
        This singleton Options class holds a globally accessible pointer
        to the application as well as the UUID of this add-in. You can add
        any data that is ought to be available throughout this program.

        Furthermore, there is the miscellaneous.h, a collection of useful
        functions for converting between dsAPI and Qt classes. These
        functions are used throughout the add-in.

Notable dsAPI functions used:
        dsApplication_c::GetMainWindow()
        dsDocument_c::GetWindow()

        dsDSWindow_c::GetFramePosition()
        dsDSWindow_c::GetFrameSize()
        dsDSWindow_c::GetGeometryPosition()
        dsDSWindow_c::GetGeometrySize()

        dsDSWindow_c::get_Visible()
        dsDSWindow_c::get_WindowState()

        dsDSWindow_c::SetFramePosition()
        dsDSWindow_c::SetFrameSize()
        dsDSWindow_c::SetGeometryPosition()
        dsDSWindow_c::sGetGeometrySize()

        dsDSWindow_c::put_Visible()
        dsDSWindow_c::put_WindowState()
*/

#include "dsApplication_c.h"
#include "dsInterfacePtr.h"
#include "Windows_global.h"

// You can append new commands like this:
// 1 - Append the header file here.
// 2 - Add the command as a private member of WindowsApplication.
// 3 - Go to bool WindowsApplication::CreateUserInterfaceAndCommands() and:
//     1 - Register your command using the registerCommand()
//         (then the command can be invoked from the command line).
//     2 - If it makes sense, add it to the user menu
//         (then the command can be invoked from the user menu as well).
#include "commands/CommandInfo.h"
#include "commands/CommandModify.h"

class Windows_EXPORT WindowsApplication
{
public:
    WindowsApplication(dsApplication_c *dsApp) : application(dsApp) {}

    void CreateUserInterfaceAndCommands();
    static const dsString appID;

private:
    dsApplication_ptr application;
    CommandInfo m_CommandInfo;
    CommandModify m_CommandModify;
};

#endif // DS_ADDIN_CONNECTION_H
